/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.network;

import java.util.function.Function;
import net.openhft.chronicle.network.HeaderTcpHandler;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.WireTypeSniffingTcpHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.connection.VanillaWireOutPublisher;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public enum LegacyHanderFactory {
    INSTANCE;


    public static <T extends NetworkContext<T>> Function<T, TcpEventHandler<T>> legacyTcpEventHandlerFactory(@NotNull Function<T, TcpHandler<T>> defaultHandedFactory, long heartbeatIntervalTicks, long heartbeatIntervalTimeout) {
        return networkContext -> {
            @NotNull TcpEventHandler handler = new TcpEventHandler(networkContext);
            @NotNull Function<Object, TcpHandler> consumer = o -> {
                if (o instanceof SessionDetailsProvider) {
                    networkContext.sessionDetails((SessionDetailsProvider)o);
                    return (TcpHandler)defaultHandedFactory.apply(networkContext);
                }
                if (o instanceof TcpHandler) {
                    return (TcpHandler)o;
                }
                throw new UnsupportedOperationException("");
            };
            @NotNull HeaderTcpHandler headerTcpHandler = new HeaderTcpHandler(handler, consumer);
            @NotNull WireTypeSniffingTcpHandler wireTypeSniffingTcpHandler = new WireTypeSniffingTcpHandler(handler, nc -> headerTcpHandler);
            handler.tcpHandler((TcpHandler)wireTypeSniffingTcpHandler);
            return handler;
        };
    }

    public static <T extends NetworkContext<T>> Function<T, TcpEventHandler<T>> legacyTcpEventHandlerFactory(@NotNull Function<T, TcpHandler<T>> defaultHandedFactory) {
        return LegacyHanderFactory.legacyTcpEventHandlerFactory(defaultHandedFactory, 20000L, 40000L);
    }

    public static <T extends NetworkContext<T>> Function<T, TcpEventHandler<T>> simpleTcpEventHandlerFactory(@NotNull Function<T, TcpHandler<T>> defaultHandedFactory, WireType text) {
        return networkContext -> {
            networkContext.wireOutPublisher((WireOutPublisher)new VanillaWireOutPublisher(WireType.TEXT));
            @NotNull TcpEventHandler handler = new TcpEventHandler(networkContext);
            handler.tcpHandler((TcpHandler)new WireTypeSniffingTcpHandler(handler, defaultHandedFactory));
            return handler;
        };
    }

    public static <T extends NetworkContext<T>> Function<T, TcpEventHandler<T>> defaultTcpEventHandlerFactory(@NotNull Function<T, TcpHandler<T>> defaultHandedFactory) {
        return networkContext -> {
            networkContext.wireOutPublisher((WireOutPublisher)new VanillaWireOutPublisher(WireType.TEXT));
            @NotNull TcpEventHandler handler = new TcpEventHandler(networkContext);
            handler.tcpHandler((TcpHandler)defaultHandedFactory.apply(networkContext));
            return handler;
        };
    }
}

