/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.network;

import java.io.IOException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.network.AcceptorEventHandler;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.VanillaNetworkContext;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.threads.EventGroup;
import net.openhft.performance.tests.network.LegacyHanderFactory;
import net.openhft.performance.tests.vanilla.tcp.EchoClientMain;
import org.jetbrains.annotations.NotNull;

class TimedEchoHandler<T extends NetworkContext<T>>
extends SimpleCloseable
implements TcpHandler<T> {
    public TimedEchoHandler(T t) {
    }

    public static <T extends NetworkContext<T>> void main(String[] args) throws IOException {
        @NotNull EventGroup eg = EventGroup.builder().withDaemon(false).build();
        eg.start();
        @NotNull AcceptorEventHandler eah = new AcceptorEventHandler("*:" + EchoClientMain.PORT, LegacyHanderFactory.legacyTcpEventHandlerFactory(TimedEchoHandler::new), () -> new VanillaNetworkContext());
        eg.addHandler((EventHandler)eah);
    }

    public void process(@NotNull Bytes<?> in, @NotNull Bytes<?> out, T nc) {
        if (in.readRemaining() == 0L) {
            return;
        }
        long toWrite = Math.min(in.readRemaining(), out.writeRemaining());
        out.write(in, in.readPosition(), toWrite);
        out.writeLong(System.nanoTime());
        in.readSkip(toWrite);
    }
}

