/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.network.AcceptorEventHandler;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.VanillaNetworkContext;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.network.tcp.ChronicleSocket;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.threads.EventGroup;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.performance.tests.network.LegacyHanderFactory;
import net.openhft.performance.tests.network.WireEchoRequestHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VerySimpleClientTest
extends NetworkTestCommon {
    public static final WireType WIRE_TYPE = WireType.BINARY;
    final Wire outWire = (Wire)WIRE_TYPE.apply((Object)Bytes.elasticByteBuffer());
    final Wire inWire = (Wire)WIRE_TYPE.apply((Object)Bytes.elasticByteBuffer());
    private EventLoop eg;
    private String expectedMessage;
    private ChronicleSocketChannel client;
    private ChronicleSocketChannel sc;

    public VerySimpleClientTest() {
        this.outWire.usePadding(TcpChannelHub.TCP_USE_PADDING);
        this.inWire.usePadding(TcpChannelHub.TCP_USE_PADDING);
    }

    @Before
    public void setUp() throws IOException {
        @NotNull String desc = "host.port";
        TCPRegistry.createServerSocketChannelFor((String)desc);
        this.eg = EventGroup.builder().build();
        this.eg.start();
        this.expectedMessage = "<my message>";
        this.createServer(desc, this.eg);
        this.client = this.createClient(this.eg, desc);
    }

    @Override
    protected void preAfter() {
        Closeable.closeQuietly((Object[])new Object[]{this.sc, this.eg, this.client});
        TcpChannelHub.closeAllHubs();
        this.inWire.bytes().releaseLast();
        this.outWire.bytes().releaseLast();
    }

    @Test
    public void test() throws IOException {
        long tid = 0L;
        this.outWire.clear();
        this.outWire.writeDocument(true, w -> w.write((CharSequence)"tid").int64(0L));
        this.outWire.writeDocument(false, w -> w.write((CharSequence)"payload").text(this.expectedMessage));
        @Nullable ByteBuffer outBuff = (ByteBuffer)this.outWire.bytes().underlyingObject();
        outBuff.clear();
        outBuff.limit((int)this.outWire.bytes().writePosition());
        while (outBuff.hasRemaining()) {
            this.client.write(outBuff);
        }
        this.readDocument(this.inWire);
        this.readDocument(this.inWire);
        this.inWire.readDocument(null, data -> Assert.assertEquals((Object)this.expectedMessage, (Object)data.read("payloadResponse").text()));
    }

    private void readDocument(@NotNull Wire inMetaDataWire) throws IOException {
        @Nullable ByteBuffer inBuff = (ByteBuffer)inMetaDataWire.bytes().underlyingObject();
        long start = inMetaDataWire.bytes().readPosition();
        while ((long)inBuff.position() + start < 4L) {
            this.client.read(inBuff);
        }
        inMetaDataWire.bytes().writePosition((long)inBuff.position());
        int len = Wires.lengthOf((int)inMetaDataWire.bytes().readInt(start));
        while ((long)inBuff.position() < (long)(4 + len) + start) {
            this.client.read(inBuff);
        }
    }

    @NotNull
    private ChronicleSocketChannel createClient(EventLoop eg, @NotNull String desc) throws IOException {
        ChronicleSocketChannel result = TCPRegistry.createSocketChannel((String)desc);
        int tcpBufferSize = 0x200000;
        ChronicleSocket socket = result.socket();
        socket.setTcpNoDelay(true);
        socket.setReceiveBufferSize(tcpBufferSize);
        socket.setSendBufferSize(tcpBufferSize);
        result.configureBlocking(true);
        return result;
    }

    private void createServer(@NotNull String desc, @NotNull EventLoop eg) throws IOException {
        @NotNull AcceptorEventHandler eah = new AcceptorEventHandler(desc, LegacyHanderFactory.simpleTcpEventHandlerFactory(WireEchoRequestHandler::new, WIRE_TYPE), VanillaNetworkContext::new);
        eg.addHandler((EventHandler)eah);
        this.sc = TCPRegistry.createSocketChannel((String)desc);
        this.sc.configureBlocking(false);
    }
}

