/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.network.AcceptorEventHandler;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.VanillaNetworkContext;
import net.openhft.chronicle.network.WireTcpHandler;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.threads.EventGroup;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.YamlLogging;
import net.openhft.performance.tests.network.LegacyHanderFactory;
import net.openhft.performance.tests.network.TestData;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WireTcpHandlerTest
extends NetworkTestCommon {
    public static final int SIZE_OF_SIZE = 4;
    private final String desc;
    private final WireType wireType;

    public WireTcpHandlerTest(String desc, WireType wireWrapper) {
        this.desc = desc;
        this.wireType = wireWrapper;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> combinations() {
        return Arrays.asList({"TextWire", WireType.TEXT}, {"BinaryWire", WireType.BINARY});
    }

    private static void testLatency(String desc, @NotNull Function<Bytes<?>, Wire> wireWrapper, ChronicleSocketChannel ... sockets) throws IOException {
        int tests = 40000;
        @NotNull long[] times = new long[tests * sockets.length];
        int count = 0;
        ByteBuffer out = ByteBuffer.allocateDirect(65536);
        Bytes outBytes = Bytes.wrapForWrite((ByteBuffer)out);
        Wire outWire = wireWrapper.apply(outBytes);
        outWire.usePadding(TcpChannelHub.TCP_USE_PADDING);
        ByteBuffer in = ByteBuffer.allocateDirect(65536);
        Bytes inBytes = Bytes.wrapForRead((ByteBuffer)in);
        Wire inWire = wireWrapper.apply(inBytes);
        @NotNull TestData td = new TestData();
        @NotNull TestData td2 = new TestData();
        for (int i = -12000; i < tests; ++i) {
            long now = System.nanoTime();
            for (ChronicleSocketChannel socket : sockets) {
                out.clear();
                outBytes.clear();
                td.value1 = i;
                td.value2 = td.value1;
                td.value3 = td.value2;
                try (DocumentContext ignored = outWire.writingDocument(false);){
                    td.write((WireOut)outWire);
                }
                out.limit((int)outBytes.writePosition());
                socket.write(out);
                if (out.remaining() > 0) {
                    throw new AssertionError((Object)"Unable to write in one go.");
                }
            }
            for (ChronicleSocketChannel socket : sockets) {
                block19: {
                    int read;
                    in.clear();
                    inBytes.clear();
                    do {
                        read = socket.read(in);
                        inBytes.readLimit((long)in.position());
                        if (inBytes.readRemaining() < 4L) continue;
                        int header = inBytes.readInt(0L);
                        int len = Wires.lengthOf((int)header);
                        if (inBytes.readRemaining() >= (long)len) {
                            td2.read((WireIn)inWire);
                        }
                        break block19;
                    } while (read >= 0);
                    throw new AssertionError((Object)"Unable to read in one go.");
                }
                if (i < 0) continue;
                times[count++] = System.nanoTime() - now;
            }
        }
        inWire.bytes().releaseLast();
        outWire.bytes().releaseLast();
        Arrays.sort(times);
        System.out.printf("%s: Loop back echo latency was %.1f/%.1f %,d/%,d %,d/%d us for 50/90 99/99.9 99.99/worst %%tile%n", desc, (double)times[times.length / 2] / 1000.0, (double)times[times.length * 9 / 10] / 1000.0, times[times.length - times.length / 100] / 1000L, times[times.length - times.length / 1000] / 1000L, times[times.length - times.length / 10000] / 1000L, times[times.length - 1] / 1000L);
    }

    @Test
    public void testProcess() throws IOException {
        boolean logging = YamlLogging.showClientReads();
        YamlLogging.setAll((boolean)false);
        try (@NotNull EventGroup eg = EventGroup.builder().build();){
            eg.start();
            TCPRegistry.createServerSocketChannelFor((String)this.desc);
            @NotNull AcceptorEventHandler eah = new AcceptorEventHandler(this.desc, LegacyHanderFactory.simpleTcpEventHandlerFactory(EchoRequestHandler::new, this.wireType), VanillaNetworkContext::new);
            eg.addHandler((EventHandler)eah);
            try (ChronicleSocketChannel sc = TCPRegistry.createSocketChannel((String)this.desc);){
                sc.configureBlocking(false);
                WireTcpHandlerTest.testLatency(this.desc, this.wireType, new ChronicleSocketChannel[]{sc});
                eg.stop();
                TcpChannelHub.closeAllHubs();
            }
        }
        YamlLogging.setAll((boolean)logging);
    }

    static class EchoRequestHandler
    extends WireTcpHandler {
        private final TestData td = new TestData();

        public EchoRequestHandler(NetworkContext networkContext) {
        }

        protected void onRead(@NotNull DocumentContext in, @NotNull WireOut out) {
            this.td.read((WireIn)in.wire());
            this.td.write((WireOut)this.outWire);
        }

        protected void onInitialize() {
        }
    }
}

