/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.third.party.frameworks.grizzly;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.performance.tests.third.party.frameworks.grizzly.GrizzlyEchoServer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrizzlyClientLatencyTest
extends NetworkTestCommon {
    private static final String DEFAULT_PORT = Integer.toString(GrizzlyEchoServer.PORT);
    private static final int PORT = Integer.parseInt(System.getProperty("port", DEFAULT_PORT));
    private static final String HOST = System.getProperty("host", "127.0.0.1");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        final @NotNull CountDownLatch finished = new CountDownLatch(1);
        Buffer buffer = MemoryManager.DEFAULT_MEMORY_MANAGER.allocate(8);
        @Nullable Connection connection = null;
        @NotNull FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        long startTime = System.nanoTime();
        @NotNull AtomicLong bytesReceived = new AtomicLong();
        filterChainBuilder.add((Filter)new BaseFilter(){
            final long[] times = new long[500000];
            final Buffer buffer2 = MemoryManager.DEFAULT_MEMORY_MANAGER.allocate(8);
            int count = -50000;
            int i;

            public NextAction handleRead(@NotNull FilterChainContext ctx) {
                if (this.i++ % 100000 == 0) {
                    System.out.print(".");
                }
                Object peerAddress = ctx.getAddress();
                Buffer msg = (Buffer)ctx.getMessage();
                if (msg.remaining() >= 8) {
                    if (this.count % 10000 == 0) {
                        System.out.print(".");
                    }
                    if (this.count >= 0) {
                        this.times[this.count] = System.nanoTime() - msg.getLong();
                        if (this.count == this.times.length - 1) {
                            Arrays.sort(this.times);
                            System.out.printf("\nLoop back echo latency was %.1f/%.1f %,d/%,d %,d/%d us for 50/90 99/99.9 99.99/worst %%tile%n", (double)this.times[this.count / 2] / 1000.0, (double)this.times[this.count * 9 / 10] / 1000.0, this.times[this.count - this.count / 100] / 1000L, this.times[this.count - this.count / 1000] / 1000L, this.times[this.count - this.count / 10000] / 1000L, this.times[this.count - 1] / 1000L);
                            try {
                                finished.await();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            return ctx.getStopAction();
                        }
                    }
                    ++this.count;
                }
                this.buffer2.clear();
                this.buffer2.putLong(System.nanoTime());
                this.buffer2.flip();
                ctx.write(peerAddress, (Object)this.buffer2, null);
                return ctx.getStopAction();
            }
        });
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.start();
            connection = (Connection)transport.connect(HOST, PORT).get(10L, TimeUnit.SECONDS);
            assert (connection != null);
            buffer.clear();
            buffer.putLong(System.nanoTime());
            buffer.flip();
            connection.write((Object)buffer);
            finished.await();
            long time = System.nanoTime() - startTime;
            System.out.printf("\nThroughput was %.1f MB/s%n", 1000.0 * (double)bytesReceived.get() / (double)time);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.shutdownNow();
        }
    }
}

