/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.third.party.frameworks.grizzly;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.performance.tests.third.party.frameworks.grizzly.GrizzlyEchoServer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.jetbrains.annotations.NotNull;

public class GrizzlyClientThroughPutTest
extends NetworkTestCommon {
    static final String DEFAULT_PORT = Integer.toString(GrizzlyEchoServer.PORT);
    static final int PORT = Integer.parseInt(System.getProperty("port", DEFAULT_PORT));
    static final String HOST = System.getProperty("host", "127.0.0.1");
    static final MemoryManager GRIZZLY_MM = MemoryManager.DEFAULT_MEMORY_MANAGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        int bufferSize = 65536;
        final @NotNull byte[] payload = new byte[65536];
        Buffer buffer = GRIZZLY_MM.allocate(65536);
        Arrays.fill(payload, (byte)88);
        Connection connection = null;
        @NotNull FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        long startTime = System.nanoTime();
        final @NotNull AtomicLong bytesReceived = new AtomicLong();
        filterChainBuilder.add((Filter)new BaseFilter(){
            final Buffer buffer2 = GRIZZLY_MM.allocate(65536);
            int i;

            public NextAction handleRead(@NotNull FilterChainContext ctx) {
                bytesReceived.addAndGet(((Buffer)ctx.getMessage()).remaining());
                if (this.i++ % 10000 == 0) {
                    this.buffer2.clear();
                }
                this.buffer2.put(payload);
                this.buffer2.flip();
                Object peerAddress = ctx.getAddress();
                ctx.write(peerAddress, (Object)this.buffer2, null);
                return ctx.getStopAction();
            }
        });
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.start();
            connection = (Connection)transport.connect(HOST, PORT).get(10L, TimeUnit.SECONDS);
            assert (connection != null);
            buffer.clear();
            buffer.put(payload);
            buffer.flip();
            connection.write((Object)buffer);
            Jvm.pause((long)10000L);
            long time = System.nanoTime() - startTime;
            System.out.printf("\nThroughput was %.1f MB/s%n", 1000.0 * (double)bytesReceived.get() / (double)time);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.shutdownNow();
        }
    }
}

