/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.third.party.frameworks.grizzly;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.jetbrains.annotations.NotNull;

public class GrizzlyEchoServer {
    static final int PORT = Integer.parseInt(System.getProperty("port", "9124"));
    private static final Logger LOG = Logger.getLogger(GrizzlyEchoServer.class.getName());
    @NotNull
    private static CountDownLatch countDownLatch = new CountDownLatch(1);

    public static void main(String[] args) throws IOException, InterruptedException {
        @NotNull FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new BaseFilter(){

            public NextAction handleRead(@NotNull FilterChainContext ctx) {
                Object peerAddress = ctx.getAddress();
                Object message = ctx.getMessage();
                ctx.write(peerAddress, message, null);
                return ctx.getStopAction();
            }
        });
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(PORT);
            transport.start();
            countDownLatch.await(50L, TimeUnit.SECONDS);
        }
        finally {
            LOG.info("Stopping transport...");
            transport.shutdownNow();
            LOG.info("Stopped transport...");
        }
    }
}

