/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.third.party.frameworks.mina;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.performance.tests.third.party.frameworks.mina.MinaEchoServer;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.jetbrains.annotations.NotNull;

public class MinaClientLatencyTest
extends NetworkTestCommon {
    public static final String DEFAULT_PORT = Integer.toString(MinaEchoServer.PORT);
    static final int PORT = Integer.parseInt(System.getProperty("port", DEFAULT_PORT));
    private static final String HOST = System.getProperty("host", "127.0.0.1");
    private static final long CONNECT_TIMEOUT = 30000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        @NotNull NioSocketConnector connector = new NioSocketConnector();
        final @NotNull long[] times = new long[500000];
        int bufferSize = 32768;
        final IoBuffer ioBuffer = IoBuffer.allocate((int)32768);
        connector.setConnectTimeoutMillis(30000L);
        connector.setHandler((IoHandler)new IoHandlerAdapter(){
            long startTime;
            int count = -50000;
            int i;

            public void sessionOpened(@NotNull IoSession session) {
                this.startTime = System.nanoTime();
                ioBuffer.clear();
                ioBuffer.putLong(System.nanoTime());
                session.write((Object)ioBuffer);
            }

            public void sessionClosed(IoSession session) {
            }

            public void messageReceived(@NotNull IoSession session, @NotNull Object msg) {
                if (((IoBuffer)msg).remaining() >= 8) {
                    if (this.count % 10000 == 0) {
                        System.out.print(".");
                    }
                    if (this.count >= 0) {
                        times[this.count] = System.nanoTime() - ((IoBuffer)msg).getLong();
                        if (this.count == times.length - 1) {
                            Arrays.sort(times);
                            System.out.printf("\nLoop back echo latency was %.1f/%.1f %,d/%,d %,d/%d us for 50/90 99/99.9 99.99/worst %%tile%n", (double)times[this.count / 2] / 1000.0, (double)times[this.count * 9 / 10] / 1000.0, times[this.count - this.count / 100] / 1000L, times[this.count - this.count / 1000] / 1000L, times[this.count - this.count / 10000] / 1000L, times[this.count - 1] / 1000L);
                            session.close(true);
                            return;
                        }
                    }
                    ++this.count;
                }
                ioBuffer.clear();
                ioBuffer.putLong(System.nanoTime());
                session.write((Object)ioBuffer);
            }

            public void messageSent(IoSession session, Object message) {
            }

            public void exceptionCaught(@NotNull IoSession session, @NotNull Throwable cause) {
                cause.printStackTrace();
                session.close(true);
            }
        });
        IoSession session = null;
        try {
            while (true) {
                try {
                    ConnectFuture future = connector.connect((SocketAddress)new InetSocketAddress(HOST, PORT));
                    future.awaitUninterruptibly();
                    session = future.getSession();
                }
                catch (RuntimeIoException e) {
                    e.printStackTrace();
                    Jvm.pause((long)500L);
                    continue;
                }
                break;
            }
        }
        finally {
            if (session != null) {
                session.getCloseFuture().awaitUninterruptibly();
            }
            connector.dispose();
        }
    }
}

