/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.third.party.frameworks.mina;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.performance.tests.third.party.frameworks.mina.MinaEchoServer;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.jetbrains.annotations.NotNull;

public class MinaClientThroughPutTest
extends NetworkTestCommon {
    private static final String DEFAULT_PORT = Integer.toString(MinaEchoServer.PORT);
    private static final int PORT = Integer.parseInt(System.getProperty("port", DEFAULT_PORT));
    private static final String HOST = System.getProperty("host", "127.0.0.1");
    private static final long CONNECT_TIMEOUT = 30000L;

    public static void main(String[] args) throws Throwable {
        IoSession session;
        @NotNull NioSocketConnector connector = new NioSocketConnector();
        final IoBuffer ioBuffer = IoBuffer.allocate((int)1024);
        connector.setConnectTimeoutMillis(30000L);
        connector.setHandler((IoHandler)new IoHandlerAdapter(){
            final int bufferSize = 64;
            int bytesReceived = 0;
            long startTime;
            @NotNull
            byte[] payload = new byte[64];
            int i;
            {
                Arrays.fill(this.payload, (byte)88);
            }

            public void sessionOpened(@NotNull IoSession session) {
                this.startTime = System.nanoTime();
                ioBuffer.clear();
                ioBuffer.put(this.payload);
                session.write((Object)ioBuffer);
            }

            public void sessionClosed(IoSession session) {
            }

            public void messageReceived(@NotNull IoSession session, @NotNull Object message) {
                this.bytesReceived += ((IoBuffer)message).remaining();
                ((IoBuffer)message).clear();
                if (this.i++ % 10000 == 0) {
                    ((IoBuffer)message).put(this.payload);
                }
                session.write(message);
                if (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.startTime) >= 10L) {
                    long time = System.nanoTime() - this.startTime;
                    System.out.printf("\nThroughput was %.1f MB/s%n", 1000.0 * (double)this.bytesReceived / (double)time);
                    session.close(true);
                }
            }

            public void messageSent(IoSession session, Object message) {
            }

            public void exceptionCaught(@NotNull IoSession session, @NotNull Throwable cause) {
                cause.printStackTrace();
                session.close(true);
            }
        });
        while (true) {
            try {
                ConnectFuture future = connector.connect((SocketAddress)new InetSocketAddress(HOST, PORT));
                future.awaitUninterruptibly();
                session = future.getSession();
            }
            catch (RuntimeIoException e) {
                e.printStackTrace();
                Jvm.pause((long)500L);
                continue;
            }
            break;
        }
        session.getCloseFuture().awaitUninterruptibly();
        connector.dispose();
    }
}

