/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.third.party.frameworks.mina;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.jetbrains.annotations.NotNull;

public class MinaEchoServer {
    static final int PORT = Integer.getInteger("port", 9120);

    public static void main(String[] args) throws IOException {
        @NotNull NioSocketAcceptor acceptor = new NioSocketAcceptor();
        acceptor.setHandler((IoHandler)new IoHandlerAdapter(){

            public void exceptionCaught(IoSession session, @NotNull Throwable cause) {
                cause.printStackTrace();
            }

            public void messageReceived(@NotNull IoSession session, Object message) {
                session.write(message);
            }

            public void sessionIdle(IoSession session, IdleStatus status) {
            }
        });
        acceptor.getSessionConfig().setReadBufferSize(2048);
        acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, 10);
        acceptor.bind((SocketAddress)new InetSocketAddress(PORT));
    }
}

