/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.third.party.frameworks.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.ReferenceCountUtil;
import java.util.Arrays;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.performance.tests.vanilla.tcp.EchoClientMain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NettyClientLatencyTest
extends NetworkTestCommon {
    static final boolean SSL = System.getProperty("ssl") != null;
    static final String HOST = System.getProperty("host", "127.0.0.1");
    static final int PORT = Integer.getInteger("port", EchoClientMain.PORT);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SSLException, InterruptedException {
        final @Nullable SslContext sslCtx = SSL ? SslContext.newClientContext((TrustManagerFactory)InsecureTrustManagerFactory.INSTANCE) : null;
        @NotNull NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            @NotNull Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(@NotNull SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (sslCtx != null) {
                        p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), HOST, PORT)});
                    }
                    p.addLast(new ChannelHandler[]{new MyChannelInboundHandler()});
                }
            });
            ChannelFuture f = b.connect(HOST, PORT).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    static class MyChannelInboundHandler
    extends ChannelInboundHandlerAdapter {
        private final ByteBuf firstMessage;
        long startTime;
        int count = -50000;
        @NotNull
        long[] times = new long[500000];

        MyChannelInboundHandler() {
            this.firstMessage = Unpooled.buffer((int)8);
            this.firstMessage.writeLong(System.nanoTime());
        }

        public void channelActive(@NotNull ChannelHandlerContext ctx) {
            this.startTime = System.nanoTime();
            ctx.writeAndFlush((Object)this.firstMessage);
        }

        public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
            try {
                if (((ByteBuf)msg).readableBytes() >= 8) {
                    if (this.count % 10000 == 0) {
                        System.out.print(".");
                    }
                    if (this.count >= 0) {
                        this.times[this.count] = System.nanoTime() - ((ByteBuf)msg).readLong();
                        if (this.count == this.times.length - 1) {
                            Arrays.sort(this.times);
                            System.out.printf("\nLoop back echo latency was %.1f/%.1f %,d/%,d %,d/%d us for 50/90 99/99.9 99.99/worst %%tile%n", (double)this.times[this.count / 2] / 1000.0, (double)this.times[this.count * 9 / 10] / 1000.0, this.times[this.count - this.count / 100] / 1000L, this.times[this.count - this.count / 1000] / 1000L, this.times[this.count - this.count / 10000] / 1000L, this.times[this.count - 1] / 1000L);
                            return;
                        }
                    }
                    ++this.count;
                }
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
            ByteBuf outMsg = ctx.alloc().buffer(8);
            outMsg.writeLong(System.nanoTime());
            ctx.writeAndFlush((Object)outMsg);
        }

        public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
            ctx.flush();
        }

        public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
            cause.printStackTrace();
            ctx.close();
        }
    }
}

