/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.third.party.frameworks.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.ReferenceCountUtil;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.performance.tests.vanilla.tcp.EchoClientMain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NettyClientThroughPutTest
extends NetworkTestCommon {
    static final boolean SSL = System.getProperty("ssl") != null;
    static final String HOST = System.getProperty("host", "127.0.0.1");
    static final int PORT = Integer.getInteger("port", EchoClientMain.PORT);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SSLException, InterruptedException {
        final @Nullable SslContext sslCtx = SSL ? SslContext.newClientContext((TrustManagerFactory)InsecureTrustManagerFactory.INSTANCE) : null;
        @NotNull NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            @NotNull Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(@NotNull SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (sslCtx != null) {
                        p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), HOST, PORT)});
                    }
                    p.addLast(new ChannelHandler[]{new MyChannelInboundHandler()});
                }
            });
            ChannelFuture f = b.connect(HOST, PORT).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    static class MyChannelInboundHandler
    extends ChannelInboundHandlerAdapter {
        final int bufferSize = 32768;
        private final ByteBuf firstMessage;
        @NotNull
        byte[] payload = new byte[32768];
        long bytesReceived = 0L;
        long startTime;
        int i = 0;

        MyChannelInboundHandler() {
            Arrays.fill(this.payload, (byte)88);
            this.firstMessage = Unpooled.buffer((int)32768);
            this.firstMessage.writeBytes(this.payload);
        }

        public void channelActive(@NotNull ChannelHandlerContext ctx) {
            this.startTime = System.nanoTime();
            ctx.writeAndFlush((Object)this.firstMessage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
            try {
                this.bytesReceived += (long)((ByteBuf)msg).readableBytes();
                if (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.startTime) >= 10L) {
                    long time = System.nanoTime() - this.startTime;
                    System.out.printf("\nThroughput was %.1f MB/s%n", 1000.0 * (double)this.bytesReceived / (double)time);
                    return;
                }
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
            ByteBuf outMsg = ctx.alloc().buffer(32768);
            outMsg.writeBytes(this.payload);
            ctx.writeAndFlush((Object)outMsg);
        }

        public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
            ctx.flush();
        }

        public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
            cause.printStackTrace();
            ctx.close();
        }
    }
}

