/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.third.party.frameworks.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import net.openhft.performance.tests.vanilla.tcp.EchoClientMain;
import org.jetbrains.annotations.NotNull;

public class NettyEchoServer {
    private int port;

    public NettyEchoServer(int port) {
        this.port = port;
    }

    public static void main(@NotNull String[] args) throws InterruptedException {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : EchoClientMain.PORT;
        new NettyEchoServer(port).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        @NotNull NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        @NotNull NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            @NotNull ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(@NotNull SocketChannel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelRead(@NotNull ChannelHandlerContext ctx, Object msg) {
                            ctx.write(msg);
                            ctx.flush();
                        }

                        public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
                            cause.printStackTrace();
                            ctx.close();
                        }
                    }});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            ChannelFuture f = b.bind(this.port).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }
}

