/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.vanilla.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.Random;
import net.openhft.affinity.Affinity;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannelFactory;
import org.jetbrains.annotations.NotNull;

public class EchoClientMain {
    public static final int PORT = Integer.getInteger("port", 8007);
    public static final int CLIENTS = Integer.getInteger("clients", 1);
    public static final int TARGET_THROUGHPUT = Integer.getInteger("throughput", 20000);
    public static final int CPU = Integer.getInteger("cpu", 0);

    public static void main(String ... args) throws IOException {
        if (CPU == 0) {
            Affinity.acquireCore();
        } else {
            System.out.println("Binding to CPU " + CPU);
            Affinity.setAffinity((int)CPU);
        }
        @NotNull String[] hostnames = args.length > 0 ? args : "localhost".split(",");
        @NotNull ChronicleSocketChannel[] sockets = new ChronicleSocketChannel[CLIENTS];
        EchoClientMain.openConnections(hostnames, PORT, sockets);
        EchoClientMain.testThroughput(sockets);
        EchoClientMain.closeConnections(sockets);
        EchoClientMain.openConnections(hostnames, PORT, sockets);
        for (int i : new int[]{100000, 80000, 60000, 50000, 40000, 30000, 20000}) {
            EchoClientMain.testByteLatency(i, sockets);
        }
        EchoClientMain.closeConnections(sockets);
    }

    private static void openConnections(@NotNull String[] hostname, int port, ChronicleSocketChannel ... sockets) throws IOException {
        for (int j = 0; j < sockets.length; ++j) {
            sockets[j] = ChronicleSocketChannelFactory.wrap((InetSocketAddress)new InetSocketAddress(hostname[j % hostname.length], port));
            sockets[j].socket().setTcpNoDelay(true);
            sockets[j].configureBlocking(false);
        }
    }

    private static void closeConnections(ChronicleSocketChannel ... sockets) throws IOException {
        for (ChronicleSocketChannel socket : sockets) {
            socket.close();
        }
    }

    private static void testThroughput(ChronicleSocketChannel ... sockets) throws IOException {
        System.out.println("Starting throughput test, clients=" + CLIENTS);
        int bufferSize = 16384;
        ByteBuffer bb = ByteBuffer.allocateDirect(bufferSize).order(ByteOrder.LITTLE_ENDIAN);
        int count = 0;
        int window = 8;
        long start = System.nanoTime();
        while ((double)(System.nanoTime() - start) < 1.0E10) {
            for (ChronicleSocketChannel socket : sockets) {
                bb.clear();
                bb.putInt(0, bb.limit());
                if (socket.write(bb) < 0) {
                    throw new AssertionError((Object)("Socket " + socket + " unable to write in one go."));
                }
            }
            if (count >= window) {
                for (ChronicleSocketChannel socket : sockets) {
                    bb.clear();
                    while (socket.read(bb) >= 0 && bb.remaining() > 0) {
                    }
                }
            }
            ++count;
        }
        for (ChronicleSocketChannel socket : sockets) {
            try {
                do {
                    bb.clear();
                } while (socket.read(bb) > 0);
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
        long time = System.nanoTime() - start;
        System.out.printf("Throughput was %.1f MB/s, clients=%d%n", 1000.0 * (double)count * (double)bufferSize * (double)sockets.length / (double)time, CLIENTS);
    }

    private static void testByteLatency(int targetThroughput, ChronicleSocketChannel ... sockets) throws IOException {
        System.out.println("Starting latency test rate: " + targetThroughput);
        int tests = Math.max(1000, Math.min(300 * targetThroughput, 5000000));
        @NotNull long[] times = new long[tests * sockets.length];
        int count = 0;
        long now = System.nanoTime();
        int interval = (int)(1.0E9 * (double)sockets.length / (double)targetThroughput);
        ByteBuffer bb = ByteBuffer.allocateDirect(40).order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(0, bb.limit());
        bb.putInt(4, 305419896);
        @NotNull Random rand = new Random();
        @NotNull long[] start = new long[sockets.length];
        for (int i = Math.max(-20000, -targetThroughput); i < tests; i += sockets.length) {
            ChronicleSocketChannel socket;
            int j;
            now += (long)rand.nextInt(2 * interval);
            while (System.nanoTime() < now) {
            }
            long next = now;
            for (j = 0; j < sockets.length; ++j) {
                socket = sockets[j];
                start[j] = next;
                long start0 = System.nanoTime();
                bb.position(0);
                while (bb.remaining() > 0) {
                    if (socket.write(bb) >= 0) continue;
                    throw new EOFException();
                }
                next = System.nanoTime() - start0;
            }
            for (j = 0; j < sockets.length; ++j) {
                socket = sockets[j];
                bb.position(0);
                while (bb.remaining() > 0) {
                    if (socket.read(bb) >= 0) continue;
                    throw new EOFException();
                }
                if (bb.getInt(4) != 305419896) {
                    throw new AssertionError((Object)"read error");
                }
                if (i < 0) continue;
                times[count++] = System.nanoTime() - start[j];
            }
        }
        System.out.println("Average time " + Arrays.stream(times).sum() / (long)times.length / 1000L);
        Arrays.sort(times);
        System.out.printf("%d clients: Loop back echo latency was %.1f/%.1f %,d/%,d %,d/%d %,d us for 50/90 99/99.9 99.99/99.999 worst %%tile%n", CLIENTS, (double)times[times.length / 2] / 1000.0, (double)times[times.length * 9 / 10] / 1000.0, times[times.length - times.length / 100] / 1000L, times[times.length - times.length / 1000] / 1000L, times[times.length - times.length / 10000 - 1] / 1000L, times[times.length - times.length / 100000 - 1] / 1000L, times[times.length - 1] / 1000L);
    }
}

