/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.vanilla.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.performance.tests.vanilla.tcp.EchoClientMain;

public class EchoMultiServerMain {
    public static final int CAPACITY = 65536;

    public static void main(String ... args) throws IOException {
        int port = args.length < 1 ? EchoClientMain.PORT : Integer.parseInt(args[0]);
        ServerSocketChannel ssc = ServerSocketChannel.open();
        ssc.bind(new InetSocketAddress(port));
        System.out.println("listening on " + ssc);
        ThreadPoolExecutor service = new ThreadPoolExecutor(0, 1000, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("connections", Boolean.valueOf(true)));
        service.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        while (true) {
            SocketChannel socket = ssc.accept();
            socket.socket().setTcpNoDelay(true);
            socket.configureBlocking(true);
            service.submit(() -> EchoMultiServerMain.process(socket));
        }
    }

    private static void process(SocketChannel socket) {
        ByteBuffer bb = ByteBuffer.allocateDirect(65536);
        ByteBuffer bb2 = ByteBuffer.allocateDirect(65536);
        try {
            while (true) {
                bb.clear();
                int len = socket.read(bb);
                if (len < 0) {
                    System.out.println("... closed " + socket + " on read");
                    socket.close();
                    return;
                }
                if (len == 0) continue;
                bb.flip();
                bb2.clear();
                bb2.put(bb);
                bb2.flip();
                while ((len = socket.write(bb2)) > 0) {
                }
                if (len < 0) break;
            }
            System.out.println("... closed " + socket + " on write");
            socket.close();
            return;
        }
        catch (IOException ioe) {
            System.out.println("... closed " + socket + " on " + ioe);
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }
}

