/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.vanilla.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.network.tcp.ChronicleServerSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleServerSocketFactory;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.performance.tests.vanilla.tcp.EchoClientMain;
import org.jetbrains.annotations.NotNull;

public class EchoServerMain {
    private static final String CPU = System.getProperty("cpu", "any");
    public static final int CAPACITY = 0x100000;

    public static void main(String ... args) throws IOException {
        int port = args.length < 1 ? EchoClientMain.PORT : Integer.parseInt(args[0]);
        ChronicleServerSocketChannel ssc = ChronicleServerSocketFactory.open((String)("localhost:" + port));
        ssc.bind(new InetSocketAddress(port));
        System.out.println("listening on " + ssc);
        @NotNull AtomicReference<ChronicleSocketChannel> nextSocket = new AtomicReference<ChronicleSocketChannel>();
        new Thread(() -> {
            AffinityLock lock = AffinityLock.acquireLock((String)CPU);
            Throwable throwable = null;
            try {
                try {
                    System.out.println("Running on CPU " + Affinity.getCpu());
                    ByteBuffer bb = ByteBuffer.allocateDirect(0x100000);
                    ByteBuffer bb2 = ByteBuffer.allocateDirect(0x100000);
                    @NotNull ArrayList<ChronicleSocketChannel> sockets = new ArrayList<ChronicleSocketChannel>();
                    block8: while (true) {
                        ChronicleSocketChannel sc;
                        if (sockets.isEmpty()) {
                            Thread.yield();
                        }
                        if ((sc = (ChronicleSocketChannel)nextSocket.getAndSet(null)) != null) {
                            sockets.add(sc);
                        }
                        int i = 0;
                        while (true) {
                            if (i >= sockets.size()) continue block8;
                            ChronicleSocketChannel socket = (ChronicleSocketChannel)sockets.get(i);
                            try {
                                bb.clear();
                                int len = socket.read(bb);
                                if (len < 0) {
                                    System.out.println("... closed " + socket + " on read");
                                    socket.close();
                                    sockets.remove(i--);
                                } else if (len != 0) {
                                    bb.flip();
                                    bb2.clear();
                                    bb2.put(bb);
                                    bb2.flip();
                                    while ((len = socket.write(bb2)) > 0) {
                                    }
                                    if (len < 0) {
                                        System.out.println("... closed " + socket + " on write");
                                        socket.close();
                                        sockets.remove(i--);
                                    }
                                }
                            }
                            catch (IOException ioe) {
                                System.out.println("... closed " + socket + " on " + ioe);
                                socket.close();
                                sockets.remove(i--);
                            }
                            ++i;
                        }
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (lock != null) {
                    if (throwable != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        lock.close();
                    }
                }
                throw throwable3;
            }
        }).start();
        block0: while (true) {
            ChronicleSocketChannel socket = ssc.accept();
            socket.socket().setTcpNoDelay(true);
            socket.configureBlocking(false);
            while (true) {
                if (nextSocket.compareAndSet(null, socket)) continue block0;
            }
            break;
        }
    }
}

