/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.values.IntValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryIntReference
implements IntValue,
Byteable {
    @Nullable
    private BytesStore bytes;
    private long offset;

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        this.bytes = bytes.bytesStore();
        this.offset = offset;
    }

    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long maxSize() {
        return 4L;
    }

    @NotNull
    public String toString() {
        return this.bytes == null ? "bytes is null" : "value: " + this.getValue();
    }

    @Override
    public int getValue() {
        return this.bytes.readInt(this.offset);
    }

    @Override
    public void setValue(int value) {
        this.bytes.writeInt(this.offset, value);
    }

    @Override
    public int getVolatileValue() {
        return this.bytes.readVolatileInt(this.offset);
    }

    @Override
    public void setOrderedValue(int value) {
        this.bytes.writeOrderedInt(this.offset, value);
    }

    @Override
    public int addValue(int delta) {
        return this.bytes.addAndGetInt(this.offset, delta);
    }

    @Override
    public int addAtomicValue(int delta) {
        return this.addValue(delta);
    }

    @Override
    public boolean compareAndSwapValue(int expected, int value) {
        return this.bytes.compareAndSwapInt(this.offset, expected, value);
    }
}

