/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RollingCycleTest {
    private final boolean lazyIndexing;

    public RollingCycleTest(boolean lazyIndexing) {
        this.lazyIndexing = lazyIndexing;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({false}, {true});
    }

    @Test
    public void testRollCycle() throws InterruptedException {
        SetTimeProvider stp = new SetTimeProvider();
        long start = System.currentTimeMillis() - 259200000L;
        stp.currentTimeMillis(start);
        String basePath = OS.TARGET + "/testRollCycle" + System.nanoTime();
        try (SingleChronicleQueue queue = ChronicleQueueBuilder.single((String)basePath).testBlockSize().timeoutMS(5L).rollCycle((RollCycle)RollCycles.TEST_DAILY).timeProvider((TimeProvider)stp).build();){
            ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            int numWritten = 0;
            for (int h = 0; h < 3; ++h) {
                stp.currentTimeMillis(start + TimeUnit.DAYS.toMillis(h));
                for (int i = 0; i < 3; ++i) {
                    appender.writeBytes((WriteBytesMarshallable)new TestBytesMarshallable(i));
                    ++numWritten;
                }
            }
            String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    690,\n    2963527434242\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 401,\n    lastIndex: 3\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 401, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  504,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 504, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 3\n  600,\n  645,\n  690,\n  0, 0, 0, 0, 0\n]\n# position: 600, header: 0\n--- !!data #binary\n00000250                                      10 6e 61 6d              \u00b7nam\n00000260 65 5f 2d 31 31 35 35 34  38 34 35 37 36 7a cb 93 e_-11554 84576z\u00b7\u00b7\n00000270 3d 38 51 d9 d4 f6 c9 2d  a3 bd 70 39 9b b7 70 e9 =8Q\u00b7\u00b7\u00b7\u00b7- \u00b7\u00b7p9\u00b7\u00b7p\u00b7\n00000280 8c 39 f0 1d 4f                                   \u00b79\u00b7\u00b7O            \n# position: 645, header: 1\n--- !!data #binary\n00000280                             10 6e 61 6d 65 5f 2d           \u00b7name_-\n00000290 31 31 35 35 38 36 39 33  32 35 6f 0e fb 68 d8 9c 11558693 25o\u00b7\u00b7h\u00b7\u00b7\n000002a0 b8 19 fc cc 2c 35 92 f9  4d 68 e5 f1 2c 55 f0 b8 \u00b7\u00b7\u00b7\u00b7,5\u00b7\u00b7 Mh\u00b7\u00b7,U\u00b7\u00b7\n000002b0 46 09                                            F\u00b7               \n# position: 690, header: 2\n--- !!data #binary\n000002b0                   10 6e  61 6d 65 5f 2d 31 31 35       \u00b7n ame_-115\n000002c0 34 37 31 35 30 37 39 90  45 c5 e6 f7 b9 1a 4b ea 4715079\u00b7 E\u00b7\u00b7\u00b7\u00b7\u00b7K\u00b7\n000002d0 c3 2f 7f 17 5f 10 01 5c  6e 62 fc cc 5e cc da    \u00b7/\u00b7\u00b7_\u00b7\u00b7\\ nb\u00b7\u00b7^\u00b7\u00b7 \n# position: 735, header: 2 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 130333 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    690,\n    2963527434242\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 401,\n    lastIndex: 3\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 401, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  504,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 504, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 3\n  600,\n  645,\n  690,\n  0, 0, 0, 0, 0\n]\n# position: 600, header: 0\n--- !!data #binary\n00000250                                      10 6e 61 6d              \u00b7nam\n00000260 65 5f 2d 31 31 35 35 34  38 34 35 37 36 7a cb 93 e_-11554 84576z\u00b7\u00b7\n00000270 3d 38 51 d9 d4 f6 c9 2d  a3 bd 70 39 9b b7 70 e9 =8Q\u00b7\u00b7\u00b7\u00b7- \u00b7\u00b7p9\u00b7\u00b7p\u00b7\n00000280 8c 39 f0 1d 4f                                   \u00b79\u00b7\u00b7O            \n# position: 645, header: 1\n--- !!data #binary\n00000280                             10 6e 61 6d 65 5f 2d           \u00b7name_-\n00000290 31 31 35 35 38 36 39 33  32 35 6f 0e fb 68 d8 9c 11558693 25o\u00b7\u00b7h\u00b7\u00b7\n000002a0 b8 19 fc cc 2c 35 92 f9  4d 68 e5 f1 2c 55 f0 b8 \u00b7\u00b7\u00b7\u00b7,5\u00b7\u00b7 Mh\u00b7\u00b7,U\u00b7\u00b7\n000002b0 46 09                                            F\u00b7               \n# position: 690, header: 2\n--- !!data #binary\n000002b0                   10 6e  61 6d 65 5f 2d 31 31 35       \u00b7n ame_-115\n000002c0 34 37 31 35 30 37 39 90  45 c5 e6 f7 b9 1a 4b ea 4715079\u00b7 E\u00b7\u00b7\u00b7\u00b7\u00b7K\u00b7\n000002d0 c3 2f 7f 17 5f 10 01 5c  6e 62 fc cc 5e cc da    \u00b7/\u00b7\u00b7_\u00b7\u00b7\\ nb\u00b7\u00b7^\u00b7\u00b7 \n# position: 735, header: 2 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 130333 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    690,\n    2963527434242\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 401,\n    lastIndex: 3\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 401, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  504,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 504, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 3\n  600,\n  645,\n  690,\n  0, 0, 0, 0, 0\n]\n# position: 600, header: 0\n--- !!data #binary\n00000250                                      10 6e 61 6d              \u00b7nam\n00000260 65 5f 2d 31 31 35 35 34  38 34 35 37 36 7a cb 93 e_-11554 84576z\u00b7\u00b7\n00000270 3d 38 51 d9 d4 f6 c9 2d  a3 bd 70 39 9b b7 70 e9 =8Q\u00b7\u00b7\u00b7\u00b7- \u00b7\u00b7p9\u00b7\u00b7p\u00b7\n00000280 8c 39 f0 1d 4f                                   \u00b79\u00b7\u00b7O            \n# position: 645, header: 1\n--- !!data #binary\n00000280                             10 6e 61 6d 65 5f 2d           \u00b7name_-\n00000290 31 31 35 35 38 36 39 33  32 35 6f 0e fb 68 d8 9c 11558693 25o\u00b7\u00b7h\u00b7\u00b7\n000002a0 b8 19 fc cc 2c 35 92 f9  4d 68 e5 f1 2c 55 f0 b8 \u00b7\u00b7\u00b7\u00b7,5\u00b7\u00b7 Mh\u00b7\u00b7,U\u00b7\u00b7\n000002b0 46 09                                            F\u00b7               \n# position: 690, header: 2\n--- !!data #binary\n000002b0                   10 6e  61 6d 65 5f 2d 31 31 35       \u00b7n ame_-115\n000002c0 34 37 31 35 30 37 39 90  45 c5 e6 f7 b9 1a 4b ea 4715079\u00b7 E\u00b7\u00b7\u00b7\u00b7\u00b7K\u00b7\n000002d0 c3 2f 7f 17 5f 10 01 5c  6e 62 fc cc 5e cc da    \u00b7/\u00b7\u00b7_\u00b7\u00b7\\ nb\u00b7\u00b7^\u00b7\u00b7 \n...\n# 130333 bytes remaining\n";
            String expectedLazy = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    491,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 401, header: 0\n--- !!data #binary\n00000190                10 6e 61  6d 65 5f 2d 31 31 35 35      \u00b7na me_-1155\n000001a0 34 38 34 35 37 36 7a cb  93 3d 38 51 d9 d4 f6 c9 484576z\u00b7 \u00b7=8Q\u00b7\u00b7\u00b7\u00b7\n000001b0 2d a3 bd 70 39 9b b7 70  e9 8c 39 f0 1d 4f       -\u00b7\u00b7p9\u00b7\u00b7p \u00b7\u00b79\u00b7\u00b7O  \n# position: 446, header: 1\n--- !!data #binary\n000001c0       10 6e 61 6d 65 5f  2d 31 31 35 35 38 36 39   \u00b7name_ -1155869\n000001d0 33 32 35 6f 0e fb 68 d8  9c b8 19 fc cc 2c 35 92 325o\u00b7\u00b7h\u00b7 \u00b7\u00b7\u00b7\u00b7\u00b7,5\u00b7\n000001e0 f9 4d 68 e5 f1 2c 55 f0  b8 46 09                \u00b7Mh\u00b7\u00b7,U\u00b7 \u00b7F\u00b7     \n# position: 491, header: 2\n--- !!data #binary\n000001e0                                               10                 \u00b7\n000001f0 6e 61 6d 65 5f 2d 31 31  35 34 37 31 35 30 37 39 name_-11 54715079\n00000200 90 45 c5 e6 f7 b9 1a 4b  ea c3 2f 7f 17 5f 10 01 \u00b7E\u00b7\u00b7\u00b7\u00b7\u00b7K \u00b7\u00b7/\u00b7\u00b7_\u00b7\u00b7\n00000210 5c 6e 62 fc cc 5e cc da                          \\nb\u00b7\u00b7^\u00b7\u00b7         \n# position: 536, header: 2 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 130532 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    491,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 401, header: 0\n--- !!data #binary\n00000190                10 6e 61  6d 65 5f 2d 31 31 35 35      \u00b7na me_-1155\n000001a0 34 38 34 35 37 36 7a cb  93 3d 38 51 d9 d4 f6 c9 484576z\u00b7 \u00b7=8Q\u00b7\u00b7\u00b7\u00b7\n000001b0 2d a3 bd 70 39 9b b7 70  e9 8c 39 f0 1d 4f       -\u00b7\u00b7p9\u00b7\u00b7p \u00b7\u00b79\u00b7\u00b7O  \n# position: 446, header: 1\n--- !!data #binary\n000001c0       10 6e 61 6d 65 5f  2d 31 31 35 35 38 36 39   \u00b7name_ -1155869\n000001d0 33 32 35 6f 0e fb 68 d8  9c b8 19 fc cc 2c 35 92 325o\u00b7\u00b7h\u00b7 \u00b7\u00b7\u00b7\u00b7\u00b7,5\u00b7\n000001e0 f9 4d 68 e5 f1 2c 55 f0  b8 46 09                \u00b7Mh\u00b7\u00b7,U\u00b7 \u00b7F\u00b7     \n# position: 491, header: 2\n--- !!data #binary\n000001e0                                               10                 \u00b7\n000001f0 6e 61 6d 65 5f 2d 31 31  35 34 37 31 35 30 37 39 name_-11 54715079\n00000200 90 45 c5 e6 f7 b9 1a 4b  ea c3 2f 7f 17 5f 10 01 \u00b7E\u00b7\u00b7\u00b7\u00b7\u00b7K \u00b7\u00b7/\u00b7\u00b7_\u00b7\u00b7\n00000210 5c 6e 62 fc cc 5e cc da                          \\nb\u00b7\u00b7^\u00b7\u00b7         \n# position: 536, header: 2 EOF\n--- !!not-ready-meta-data! #binary\n...\n# 130532 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    491,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 401, header: 0\n--- !!data #binary\n00000190                10 6e 61  6d 65 5f 2d 31 31 35 35      \u00b7na me_-1155\n000001a0 34 38 34 35 37 36 7a cb  93 3d 38 51 d9 d4 f6 c9 484576z\u00b7 \u00b7=8Q\u00b7\u00b7\u00b7\u00b7\n000001b0 2d a3 bd 70 39 9b b7 70  e9 8c 39 f0 1d 4f       -\u00b7\u00b7p9\u00b7\u00b7p \u00b7\u00b79\u00b7\u00b7O  \n# position: 446, header: 1\n--- !!data #binary\n000001c0       10 6e 61 6d 65 5f  2d 31 31 35 35 38 36 39   \u00b7name_ -1155869\n000001d0 33 32 35 6f 0e fb 68 d8  9c b8 19 fc cc 2c 35 92 325o\u00b7\u00b7h\u00b7 \u00b7\u00b7\u00b7\u00b7\u00b7,5\u00b7\n000001e0 f9 4d 68 e5 f1 2c 55 f0  b8 46 09                \u00b7Mh\u00b7\u00b7,U\u00b7 \u00b7F\u00b7     \n# position: 491, header: 2\n--- !!data #binary\n000001e0                                               10                 \u00b7\n000001f0 6e 61 6d 65 5f 2d 31 31  35 34 37 31 35 30 37 39 name_-11 54715079\n00000200 90 45 c5 e6 f7 b9 1a 4b  ea c3 2f 7f 17 5f 10 01 \u00b7E\u00b7\u00b7\u00b7\u00b7\u00b7K \u00b7\u00b7/\u00b7\u00b7_\u00b7\u00b7\n00000210 5c 6e 62 fc cc 5e cc da                          \\nb\u00b7\u00b7^\u00b7\u00b7         \n...\n# 130532 bytes remaining\n";
            Assert.assertEquals((Object)(this.lazyIndexing ? expectedLazy : expectedEager), (Object)queue.dump());
            System.out.println("Wrote: " + numWritten + " messages");
            long numRead = 0L;
            TestBytesMarshallable reusableData = new TestBytesMarshallable(0);
            ExcerptTailer currentPosTailer = queue.createTailer().toStart();
            ExcerptTailer endPosTailer = queue.createTailer().toEnd();
            while (currentPosTailer.index() < endPosTailer.index()) {
                try {
                    Assert.assertTrue((boolean)currentPosTailer.readBytes((ReadBytesMarshallable)reusableData));
                }
                catch (AssertionError e) {
                    System.err.println("Could not read data at index: " + numRead + " " + Long.toHexString(currentPosTailer.cycle()) + " " + Long.toHexString(currentPosTailer.index()) + " " + ((Throwable)((Object)e)).getMessage() + " " + e);
                    throw e;
                }
                ++numRead;
            }
            Assert.assertFalse((boolean)currentPosTailer.readBytes((ReadBytesMarshallable)reusableData));
            System.out.println("Wrote " + numWritten + " Read " + numRead);
            try {
                IOTools.deleteDirWithFiles((String)basePath, (int)2);
            }
            catch (IORuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    private static class TestBytesMarshallable
    implements WriteBytesMarshallable,
    ReadBytesMarshallable {
        @Nullable
        String _name;
        long _value1;
        long _value2;
        long _value3;

        public TestBytesMarshallable(int i) {
            Random rand = new Random(i);
            this._name = "name_" + rand.nextInt();
            this._value1 = rand.nextLong();
            this._value2 = rand.nextLong();
            this._value3 = rand.nextLong();
        }

        public void writeMarshallable(@NotNull BytesOut bytes) {
            bytes.writeUtf8(this._name);
            bytes.writeLong(this._value1);
            bytes.writeLong(this._value2);
            bytes.writeLong(this._value3);
        }

        public void readMarshallable(@NotNull BytesIn bytes) throws IORuntimeException {
            this._name = bytes.readUtf8();
            this._value1 = bytes.readLong();
            this._value2 = bytes.readLong();
            this._value3 = bytes.readLong();
        }
    }
}

