/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TailerDirectionTest
extends ChronicleQueueTestBase {
    public static final int MILLIS = 86400000;
    private static final String TEST_MESSAGE_PREFIX = "Test entry: ";

    private String testMessage(int id) {
        return TEST_MESSAGE_PREFIX + id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long appendEntry(@NotNull ExcerptAppender appender, String msg) {
        try (DocumentContext dc = appender.writingDocument();){
            dc.wire().write().text(msg);
            long l = dc.index();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readNextEntry(@NotNull ExcerptTailer tailer) {
        try (DocumentContext dc = tailer.readingDocument();){
            if (dc.isPresent()) {
                Object parent = dc.wire().parent();
                assert (parent == tailer);
                String string = dc.wire().read().text();
                return string;
            }
            String string = null;
            return string;
        }
    }

    @Test
    public void testTailerForwardBackwardRead() throws Exception {
        String basePath = OS.TARGET + "/tailerForwardBackward-" + System.nanoTime();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((String)basePath).testBlockSize().rollCycle((RollCycle)RollCycles.HOURLY).build();
        ExcerptAppender appender = queue.acquireAppender();
        ExcerptTailer tailer = queue.createTailer();
        HashMap<String, Long> msgIndexes = new HashMap<String, Long>();
        for (int i = 0; i < 4; ++i) {
            String msg = this.testMessage(i);
            long idx = this.appendEntry(appender, msg);
            msgIndexes.put(msg, idx);
        }
        Assert.assertEquals((String)"[Forward 1] Wrong message 0", (Object)this.testMessage(0), (Object)this.readNextEntry(tailer));
        Assert.assertEquals((String)"[Forward 1] Wrong Tailer index after reading msg 0", (long)((Long)msgIndexes.get(this.testMessage(1))), (long)tailer.index());
        Assert.assertEquals((String)"[Forward 1] Wrong message 1", (Object)this.testMessage(1), (Object)this.readNextEntry(tailer));
        Assert.assertEquals((String)"[Forward 1] Wrong Tailer index after reading msg 1", (long)((Long)msgIndexes.get(this.testMessage(2))), (long)tailer.index());
        tailer.direction(TailerDirection.BACKWARD);
        Assert.assertEquals((String)"[Backward] Wrong message 2", (Object)this.testMessage(2), (Object)this.readNextEntry(tailer));
        Assert.assertEquals((String)"[Backward] Wrong Tailer index after reading msg 2", (long)((Long)msgIndexes.get(this.testMessage(1))), (long)tailer.index());
        Assert.assertEquals((String)"[Backward] Wrong message 1", (Object)this.testMessage(1), (Object)this.readNextEntry(tailer));
        Assert.assertEquals((String)"[Backward] Wrong Tailer index after reading msg 1", (long)((Long)msgIndexes.get(this.testMessage(0))), (long)tailer.index());
        Assert.assertEquals((String)"[Backward] Wrong message 0", (Object)this.testMessage(0), (Object)this.readNextEntry(tailer));
        String res = this.readNextEntry(tailer);
        Assert.assertTrue((String)("Backward: res is" + res), (res == null ? 1 : 0) != 0);
        tailer.direction(TailerDirection.FORWARD);
        res = this.readNextEntry(tailer);
        Assert.assertTrue((String)("Forward: res is" + res), (res == null ? 1 : 0) != 0);
        Assert.assertEquals((String)"[Forward 2] Wrong message 0", (Object)this.testMessage(0), (Object)this.readNextEntry(tailer));
        Assert.assertEquals((String)"[Forward 2] Wrong Tailer index after reading msg 0", (long)((Long)msgIndexes.get(this.testMessage(1))), (long)tailer.index());
        Assert.assertEquals((String)"[Forward 2] Wrong message 1", (Object)this.testMessage(1), (Object)this.readNextEntry(tailer));
        Assert.assertEquals((String)"[Forward 2] Wrong Tailer index after reading msg 1", (long)((Long)msgIndexes.get(this.testMessage(2))), (long)tailer.index());
        queue.close();
    }

    @Test
    public void testTailerBackwardsReadBeyondCycle() throws Exception {
        int i;
        File basePath = DirectoryUtils.tempDir("tailerForwardBackwardBeyondCycle");
        SetTimeProvider timeProvider = new SetTimeProvider();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)basePath).testBlockSize().timeProvider((TimeProvider)timeProvider).build();
        ExcerptAppender appender = queue.acquireAppender();
        ArrayList<Long> indexes = new ArrayList<Long>();
        ArrayList<String> messages = new ArrayList<String>();
        for (int d = -7; d <= 0; ++d) {
            if (d == -5 || d == -4) continue;
            timeProvider.currentTimeMillis(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(d));
            for (i = 0; i < 3; ++i) {
                String msg = this.testMessage(indexes.size());
                long idx = this.appendEntry(appender, msg);
                messages.add(msg);
                indexes.add(idx);
            }
        }
        ExcerptTailer tailer = queue.createTailer().direction(TailerDirection.BACKWARD).toEnd();
        for (i = indexes.size() - 1; i >= 0; --i) {
            long index = (Long)indexes.get(i);
            String msg = (String)messages.get(i);
            Assert.assertEquals((String)("[Backward] Wrong index " + i), (long)index, (long)tailer.index());
            Assert.assertEquals((String)("[Backward] Wrong message " + i), (Object)msg, (Object)this.readNextEntry(tailer));
        }
        queue.close();
    }

    @Override
    @After
    public void checkRegisteredBytes() {
        BytesUtil.checkRegisteredBytes();
    }
}

