/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AppenderLockOnlyAppliesToFileTest {
    private static final RollCycle ROLL_CYCLE = RollCycles.TEST_SECONDLY;
    private static final int TIMEOUT_MS = 1500;
    private static final int WAIT_FOR_ROLL_MS = 1100;

    @Ignore(value="fails too often")
    @Test
    public void concurrentLockItUp() throws InterruptedException {
        AtomicReference writerQueueFile = new AtomicReference();
        File path = DirectoryUtils.tempDir(this.getClass().getSimpleName());
        SingleChronicleQueueBuilder builder = ChronicleQueueBuilder.single((File)path).sourceId(1).rollCycle(ROLL_CYCLE).timeoutMS(1500L);
        DocumentContext initialContext = builder.build().acquireAppender().writingDocument();
        initialContext.wire().writeText((CharSequence)"abcd");
        String initialFile = this.getFilename(initialContext);
        long afterInitialWrite = System.currentTimeMillis();
        CountDownLatch writerStarted = new CountDownLatch(1);
        CountDownLatch writerFinished = new CountDownLatch(1);
        Thread writerThread = new Thread(() -> {
            ExcerptAppender appender = builder.build().acquireAppender();
            writerStarted.countDown();
            Jvm.pause((long)1100L);
            try (DocumentContext context = appender.writingDocument();){
                writerQueueFile.set(this.getFilename(context));
                Wire wire = context.wire();
                wire.writeText((CharSequence)"hello");
                writerFinished.countDown();
            }
        });
        writerThread.start();
        Assert.assertTrue((String)"Writer thread not started", (boolean)writerStarted.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"Writer thread completed before timeout", (boolean)writerFinished.await(1150L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Threads wrote to different queue cycles, so no locking occurred", (boolean)initialFile.equals(writerQueueFile.get()));
        Assert.assertTrue((String)"We are within timeout", (System.currentTimeMillis() < afterInitialWrite + 1500L ? 1 : 0) != 0);
        ExcerptTailer tailer = builder.build().createTailer();
        try (DocumentContext rd = tailer.readingDocument();){
            Assert.assertFalse((String)"We are outside timeout", (System.currentTimeMillis() < afterInitialWrite + 1500L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Something was written", (boolean)rd.isPresent());
            String value = rd.wire().readText();
            Assert.assertEquals((String)"the first (locked) write is lost", (Object)"hello", (Object)value);
        }
        rd = tailer.readingDocument();
        var13_13 = null;
        try {
            Assert.assertFalse((String)"Should be only one message in the queue", (boolean)rd.isPresent());
        }
        catch (Throwable throwable) {
            var13_13 = throwable;
            throw throwable;
        }
        finally {
            if (rd != null) {
                if (var13_13 != null) {
                    try {
                        rd.close();
                    }
                    catch (Throwable throwable) {
                        var13_13.addSuppressed(throwable);
                    }
                } else {
                    rd.close();
                }
            }
        }
        try {
            initialContext.close();
            Assert.fail((String)"close should have thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @NotNull
    private String getFilename(DocumentContext context) {
        return ((MappedBytes)context.wire().bytes()).mappedFile().file().getName();
    }

    @After
    public void checkMappedFiles() {
        MappedFile.checkMappedFiles();
    }
}

