/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NotCompleteTest {
    private final boolean lazyIndexing;

    public NotCompleteTest(String type, boolean lazyIndexing) {
        this.lazyIndexing = lazyIndexing;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"eager", false}, {"lazy", true});
    }

    @Test
    public void testUsingANotCompleteQueue() throws TimeoutException, ExecutionException, InterruptedException {
        Throwable throwable;
        DocumentContext dc;
        BinaryLongReference.startCollecting();
        File tmpDir = DirectoryUtils.tempDir("testUsingANotCompleteQueue");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            dc = appender.writingDocument();
            throwable = null;
            try {
                dc.wire().write((CharSequence)"some").text("data");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Thread.sleep(100L);
            BinaryLongReference.forceAllToNotCompleteState();
        }
        queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeoutMS(500L).build();
        var3_3 = null;
        try {
            ExcerptTailer tailer = queue.createTailer();
            dc = tailer.readingDocument();
            throwable = null;
            try {
                Assert.assertEquals((Object)"data", (Object)dc.wire().read(() -> "some").text());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var3_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable7) {
                        var3_3.addSuppressed(throwable7);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testUsingANotCompleteArrayQueue() throws TimeoutException, ExecutionException, InterruptedException {
        Throwable throwable;
        DocumentContext dc;
        BinaryLongArrayReference.startCollecting();
        File tmpDir = DirectoryUtils.tempDir("testUsingANotCompleteArrayQueue");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            dc = appender.writingDocument();
            throwable = null;
            try {
                dc.wire().write((CharSequence)"some").text("data");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Thread.sleep(100L);
            BinaryLongArrayReference.forceAllToNotCompleteState();
        }
        queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeoutMS(500L).build();
        var3_3 = null;
        try {
            ExcerptTailer tailer = queue.createTailer();
            dc = tailer.readingDocument();
            throwable = null;
            try {
                Assert.assertEquals((Object)"data", (Object)dc.wire().read(() -> "some").text());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var3_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable7) {
                        var3_3.addSuppressed(throwable7);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testMessageLeftNotComplete() throws TimeoutException, ExecutionException, InterruptedException {
        Object expectedLazy;
        String expectedEager;
        DocumentContext dc;
        File tmpDir = DirectoryUtils.tempDir("testMessageLeftNotComplete");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            DocumentContext dc2 = appender.writingDocument();
            dc2.wire().write((CharSequence)"some").text("data");
        }
        Object singleChronicleQueue = null;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().build();){
            ExcerptTailer tailer = queue.createTailer();
            dc = tailer.readingDocument();
            Throwable throwable = null;
            try {
                Assert.assertFalse((boolean)dc.isPresent());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    0,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 401,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 401, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  504,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 504, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 600, header: -1 or 0\n--- !!not-ready-data! #binary\n...\n# 130468 bytes remaining\n";
            expectedLazy = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    0,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 401, header: -1 or 0\n--- !!not-ready-data! #binary\n...\n# 130667 bytes remaining\n";
            Assert.assertEquals((Object)(this.lazyIndexing ? expectedLazy : expectedEager), (Object)queue.dump());
        }
        queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeoutMS(500L).build();
        var4_4 = null;
        try {
            ExcerptAppender appender = queue.acquireAppender();
            dc = appender.writingDocument();
            expectedLazy = null;
            try {
                dc.wire().write((CharSequence)"some").text("data");
            }
            catch (Throwable throwable) {
                expectedLazy = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (expectedLazy != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)expectedLazy).addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    33372,\n    143331648602112\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 401,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 401, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  504,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 504, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  33372,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 600, header: -1\n--- !!meta-data #binary\n\"!! Skipped due to recovery of locked header !!\"\n# position: 33372, header: 0\n--- !!data #binary\nsome: data\n...\n# 97682 bytes remaining\n";
            expectedLazy = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    33368,\n    143314468732928\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 33172,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0\n}\n# position: 401, header: -1\n--- !!meta-data #binary\n\"!! Skipped due to recovery of locked header !!\"\n# position: 33172, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  33272,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 33272, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  33368,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 33368, header: 0\n--- !!data #binary\nsome: data\n...\n# 97686 bytes remaining\n";
            Assert.assertEquals((Object)(this.lazyIndexing ? expectedLazy : expectedEager), (Object)queue.dump());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var4_4 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testInterruptedDuringSerialisation() throws TimeoutException, ExecutionException, InterruptedException {
        File tmpDir = DirectoryUtils.tempDir("testInterruptedDuringSerialisation_" + (this.lazyIndexing ? "lazy" : "eager"));
        DirectoryUtils.deleteDir(tmpDir);
        tmpDir.mkdirs();
        List names = Collections.synchronizedList(new ArrayList());
        Person person1 = new Person(40, "Terry");
        Person person2 = new Person(50, "Arthur");
        Person person3 = new Person(60, "June");
        Person person4 = new Person(70, "Percy");
        try (SingleChronicleQueue queueReader = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeoutMS(500L).build();){
            ExcerptTailer tailer = queueReader.createTailer();
            MethodReader reader = tailer.methodReader(new Object[]{person -> names.add(person.name)});
            StringBuilder queueDumpBeforeInterruptedWrite = new StringBuilder();
            Thread writerThread = new Thread(() -> {
                try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
                    ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
                    PersonListener proxy = (PersonListener)appender.methodWriterBuilder(PersonListener.class).get();
                    proxy.accept(person1);
                    queueDumpBeforeInterruptedWrite.append(queue.dump());
                    proxy.accept(person2);
                    try {
                        proxy.accept(person3);
                        Assert.fail((String)"should not have accepted another write");
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            });
            writerThread.start();
            writerThread.join();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
                Assert.assertEquals((Object)queueDumpBeforeInterruptedWrite.toString(), (Object)queue.dump());
            }
            Assert.assertTrue((boolean)reader.readOne());
            Assert.assertEquals((long)1L, (long)names.size());
            Assert.assertEquals((Object)person1.name, names.get(0));
            Assert.assertFalse((boolean)reader.readOne());
            queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();
            var14_16 = null;
            try {
                ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
                PersonListener proxy = (PersonListener)appender.methodWriterBuilder(PersonListener.class).get();
                proxy.accept(person4);
            }
            catch (Throwable throwable) {
                var14_16 = throwable;
                throw throwable;
            }
            finally {
                if (queue != null) {
                    if (var14_16 != null) {
                        try {
                            queue.close();
                        }
                        catch (Throwable throwable) {
                            var14_16.addSuppressed(throwable);
                        }
                    } else {
                        queue.close();
                    }
                }
            }
            Assert.assertTrue((boolean)reader.readOne());
            Assert.assertEquals((long)2L, (long)names.size());
            Assert.assertEquals((Object)person4.name, names.get(1));
            Assert.assertFalse((boolean)reader.readOne());
        }
    }

    @After
    public void checkMappedFiles() {
        MappedFile.checkMappedFiles();
    }

    private class Person
    implements Marshallable {
        static final String INTERRUPT = "Arthur";
        final int age;
        final String name;

        public Person(int age, String name) {
            this.age = age;
            this.name = name;
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write((CharSequence)"age").int32(this.age);
            if (INTERRUPT.equals(this.name)) {
                Thread.currentThread().interrupt();
            } else {
                wire.write((CharSequence)"name").text(this.name);
            }
        }

        public String toString() {
            return "Person{age=" + this.age + ", name='" + this.name + '\'' + '}';
        }
    }

    private static interface PersonListener {
        public void accept(Person var1);
    }
}

