/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.TailerState;
import net.openhft.chronicle.queue.impl.single.AppenderFileHandleLeakTest;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public final class TailerIndexingQueueTest {
    private final File path = DirectoryUtils.tempDir(AppenderFileHandleLeakTest.class.getSimpleName() + "-" + System.nanoTime());
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());

    @Test
    public void tailerShouldBeAbleToMoveBackwardFromEndOfCycle() throws Exception {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (SingleChronicleQueue queue = TailerIndexingQueueTest.createQueue(this.path, this.clock::get);){
            ExcerptAppender appender = queue.acquireAppender();
            IntStream.range(0, 5).forEach(i -> {
                try (DocumentContext ctx = appender.writingDocument();){
                    ctx.wire().write().int32(i);
                    this.clock.addAndGet(TimeUnit.SECONDS.toMillis(10L));
                }
            });
        }
        Path firstFile = Files.list(this.path.toPath()).sorted(Comparator.comparing(Path::toString)).findFirst().orElseThrow(AssertionError::new);
        Files.list(this.path.toPath()).filter(p -> !p.equals(firstFile)).forEach(TailerIndexingQueueTest::deleteFile);
        try (SingleChronicleQueue queue = TailerIndexingQueueTest.createQueue(this.path, (TimeProvider)SystemTimeProvider.INSTANCE);){
            ExcerptTailer tailer = queue.createTailer().toEnd();
            try (DocumentContext readCtx = tailer.readingDocument();){
                Assert.assertThat((Object)readCtx.isPresent(), (Matcher)CoreMatchers.is((Object)false));
            }
            Assert.assertThat((Object)tailer.state(), (Matcher)CoreMatchers.is((Object)TailerState.END_OF_CYCLE));
            tailer.direction(TailerDirection.BACKWARD);
            tailer.toEnd();
            Assert.assertThat((Object)tailer.readingDocument().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @After
    public void deleteDir() throws Exception {
        DirectoryUtils.deleteDir(this.path);
    }

    private static void deleteFile(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            throw new AssertionError("Could not delete", e);
        }
    }

    private static SingleChronicleQueue createQueue(File path, TimeProvider timeProvider) {
        return SingleChronicleQueueBuilder.binary((File)path).timeProvider(timeProvider).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).testBlockSize().wireType(WireType.BINARY).build();
    }
}

