/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.text.ParseException;
import java.util.Comparator;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.BinarySearch;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestBinarySearch
extends ChronicleQueueTestBase {
    private static final int MAX_NUMBER_OF_TESTED_MESSAGES = 50;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBinarySearch() throws ParseException {
        SetTimeProvider stp = new SetTimeProvider();
        long time = 0L;
        stp.currentTimeMillis(time);
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)stp).build();){
            ExcerptAppender appender = queue.acquireAppender();
            for (int i = 0; i < 50; ++i) {
                try (DocumentContext dc = appender.writingDocument();){
                    MyData myData = new MyData();
                    myData.key = i;
                    myData.value = "some value where the key=" + String.valueOf(i);
                    dc.wire().getValueOut().typedMarshallable((WriteMarshallable)myData);
                    stp.currentTimeMillis(time += 300L);
                    continue;
                }
            }
            for (int j = 0; j < 50; ++j) {
                Wire key = this.toWire(j);
                Comparator comparator = (o1, o2) -> {
                    long readPositionO1 = o1.bytes().readPosition();
                    long readPositionO2 = o2.bytes().readPosition();
                    try {
                        int compare;
                        MyData myDataO1 = null;
                        MyData myDataO2 = null;
                        try (DocumentContext dc = o1.readingDocument();){
                            myDataO1 = (MyData)((Object)((Object)dc.wire().getValueIn().typedMarshallable()));
                            assert (myDataO1.value != null);
                        }
                        dc = o2.readingDocument();
                        var9_8 = null;
                        try {
                            myDataO2 = (MyData)((Object)((Object)dc.wire().getValueIn().typedMarshallable()));
                            assert (myDataO2.value != null);
                        }
                        catch (Throwable throwable) {
                            var9_8 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (dc != null) {
                                if (var9_8 != null) {
                                    try {
                                        dc.close();
                                    }
                                    catch (Throwable throwable) {
                                        var9_8.addSuppressed(throwable);
                                    }
                                } else {
                                    dc.close();
                                }
                            }
                        }
                        int n = compare = Integer.compare(myDataO1.key, myDataO2.key);
                        return n;
                    }
                    finally {
                        o1.bytes().readPosition(readPositionO1);
                        o2.bytes().readPosition(readPositionO2);
                    }
                };
                long index = BinarySearch.search((SingleChronicleQueue)queue, (Wire)key, (Comparator)comparator);
                ExcerptTailer tailer = queue.createTailer();
                tailer.moveToIndex(index);
                try (DocumentContext documentContext = tailer.readingDocument();){
                    Assert.assertTrue((boolean)documentContext.toString().contains("some value where the key=" + j));
                }
                key.bytes().release();
            }
        }
        finally {
            System.gc();
            TestBinarySearch.deleteDir(tmpDir);
        }
    }

    @NotNull
    private Wire toWire(int key) {
        MyData myData = new MyData();
        myData.key = key;
        myData.value = Integer.toString(key);
        Wire result = (Wire)WireType.BINARY.apply((Object)Bytes.elasticByteBuffer());
        try (DocumentContext dc = result.writingDocument();){
            dc.wire().getValueOut().typedMarshallable((WriteMarshallable)myData);
        }
        return result;
    }

    @After
    public void checkMappedFiles() {
        MappedFile.checkMappedFiles();
    }

    public static class MyData
    extends AbstractMarshallable {
        private int key;
        private String value;

        @NotNull
        public String toString() {
            return "MyData{key=" + this.key + ", value='" + this.value + '\'' + '}';
        }
    }
}

