/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.micros;

import java.util.Map;
import java.util.TreeMap;
import net.openhft.chronicle.queue.micros.MarketDataListener;
import net.openhft.chronicle.queue.micros.SidedMarketDataListener;
import net.openhft.chronicle.queue.micros.SidedPrice;
import net.openhft.chronicle.queue.micros.TopOfBookPrice;
import org.jetbrains.annotations.NotNull;

public class SidedMarketDataCombiner
implements SidedMarketDataListener {
    final MarketDataListener mdListener;
    final Map<String, TopOfBookPrice> priceMap = new TreeMap<String, TopOfBookPrice>();

    public SidedMarketDataCombiner(MarketDataListener mdListener) {
        this.mdListener = mdListener;
    }

    @Override
    public void onSidedPrice(@NotNull SidedPrice sidedPrice) {
        TopOfBookPrice price = this.priceMap.computeIfAbsent(sidedPrice.symbol, TopOfBookPrice::new);
        if (price.combine(sidedPrice)) {
            this.mdListener.onTopOfBookPrice(price);
        }
    }
}

