/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public final class MappedMemoryUnmappingTest {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    private long baselineMappedMemory = 0L;

    @Test
    public void shouldUnmapMemoryAsCycleRolls() throws Exception {
        AtomicLong clock = new AtomicLong(System.currentTimeMillis());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.tmp.newFolder()).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider(clock::get).build();){
            for (int i = 0; i < 100; ++i) {
                queue.acquireAppender().writeDocument((Object)System.nanoTime(), (d, t) -> d.int64(t.longValue()));
                clock.addAndGet(TimeUnit.SECONDS.toMillis(1L));
                if (this.baselineMappedMemory != 0L) continue;
                this.baselineMappedMemory = OS.memoryMapped();
            }
        }
        long timeoutAt = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        while (System.currentTimeMillis() < timeoutAt) {
            if (OS.memoryMapped() >= 2L * this.baselineMappedMemory) continue;
            return;
        }
        Assert.fail((String)String.format("Mapped memory (%dB) did not fall below threshold (%dB)", OS.memoryMapped(), 2L * this.baselineMappedMemory));
    }
}

