/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NotCompleteTest {
    private final boolean lazyIndexing;

    public NotCompleteTest(String type, boolean lazyIndexing) {
        this.lazyIndexing = lazyIndexing;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"eager", false}, {"lazy", true});
    }

    @Test
    public void testUsingANotCompleteQueue() throws InterruptedException {
        Throwable throwable;
        DocumentContext dc;
        BinaryLongReference.startCollecting();
        File tmpDir = DirectoryUtils.tempDir("testUsingANotCompleteQueue");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            dc = appender.writingDocument();
            throwable = null;
            try {
                dc.wire().write((CharSequence)"some").text("data");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Thread.sleep(100L);
            BinaryLongReference.forceAllToNotCompleteState();
        }
        queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeoutMS(500L).build();
        var3_3 = null;
        try {
            ExcerptTailer tailer = queue.createTailer();
            dc = tailer.readingDocument();
            throwable = null;
            try {
                Assert.assertEquals((Object)"data", (Object)dc.wire().read(() -> "some").text());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var3_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable7) {
                        var3_3.addSuppressed(throwable7);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testUsingANotCompleteArrayQueue() throws InterruptedException {
        Throwable throwable;
        DocumentContext dc;
        BinaryLongArrayReference.startCollecting();
        File tmpDir = DirectoryUtils.tempDir("testUsingANotCompleteArrayQueue");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            dc = appender.writingDocument();
            throwable = null;
            try {
                dc.wire().write((CharSequence)"some").text("data");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            Thread.sleep(100L);
            BinaryLongArrayReference.forceAllToNotCompleteState();
        }
        queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeoutMS(500L).build();
        var3_3 = null;
        try {
            ExcerptTailer tailer = queue.createTailer();
            dc = tailer.readingDocument();
            throwable = null;
            try {
                Assert.assertEquals((Object)"data", (Object)dc.wire().read(() -> "some").text());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var3_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable7) {
                        var3_3.addSuppressed(throwable7);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testMessageLeftNotComplete() {
        Object expectedLazy;
        String expectedEager;
        DocumentContext dc;
        File tmpDir = DirectoryUtils.tempDir("testMessageLeftNotComplete");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
            DocumentContext dc2 = appender.writingDocument();
            dc2.wire().write((CharSequence)"some").text("data");
        }
        Object singleChronicleQueue = null;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().build();){
            ExcerptTailer tailer = queue.createTailer();
            dc = tailer.readingDocument();
            Throwable throwable = null;
            try {
                Assert.assertFalse((boolean)dc.isPresent());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc != null) {
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    0,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 442,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 640, header: -1 or 0\n--- !!not-ready-data! #binary\n...\n# 130428 bytes remaining\n";
            expectedLazy = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    0,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1 or 0\n--- !!not-ready-data! #binary\n...\n# 130626 bytes remaining\n";
            Assert.assertEquals((Object)(this.lazyIndexing ? expectedLazy : expectedEager), (Object)queue.dump());
        }
        queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeoutMS(500L).build();
        var4_4 = null;
        try {
            ExcerptAppender appender = queue.acquireAppender();
            dc = appender.writingDocument();
            expectedLazy = null;
            try {
                dc.wire().write((CharSequence)"some").text("data");
            }
            catch (Throwable throwable) {
                expectedLazy = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (expectedLazy != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)expectedLazy).addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    33412,\n    143503447293952\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 442,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  544,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 544, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  33412,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 640, header: -1\n--- !!meta-data #binary\n\"!! Skipped due to recovery of locked header !!\"\n# position: 33412, header: 0\n--- !!data #binary\nsome: data\n...\n# 97642 bytes remaining\n";
            expectedLazy = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    33408,\n    143486267424768\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 33212,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: -1\n--- !!meta-data #binary\n\"!! Skipped due to recovery of locked header !!\"\n# position: 33212, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  33312,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 33312, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  33408,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 33408, header: 0\n--- !!data #binary\nsome: data\n...\n# 97646 bytes remaining\n";
            Assert.assertEquals((Object)(this.lazyIndexing ? expectedLazy : expectedEager), (Object)queue.dump());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var4_4 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void testInterruptedDuringSerialisation() throws InterruptedException {
        File tmpDir = DirectoryUtils.tempDir("testInterruptedDuringSerialisation_" + (this.lazyIndexing ? "lazy" : "eager"));
        DirectoryUtils.deleteDir(tmpDir);
        tmpDir.mkdirs();
        List names = Collections.synchronizedList(new ArrayList());
        Person person1 = new Person(40, "Terry");
        Person interrupter = new Person(50, "Arthur");
        Person thrower = new Person(80, "Thrower");
        Person person2 = new Person(90, "Bert");
        try (SingleChronicleQueue queueReader = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).timeoutMS(500L).build();
             SingleChronicleQueue queueWriter = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            String dump;
            ExcerptTailer tailer = queueReader.createTailer();
            MethodReader reader = tailer.methodReader(new Object[]{person -> names.add(person.name)});
            StringBuilder queueDumpBeforeInterruptedWrite = new StringBuilder();
            this.doWrite((ChronicleQueue)queueWriter, (proxy, queue) -> {
                proxy.accept(person1);
                queueDumpBeforeInterruptedWrite.append(queue.dump());
            });
            String cleanedQueueDump = this.cleanQueueDump(queueDumpBeforeInterruptedWrite.toString());
            Thread writerThread = new Thread(() -> this.lambda$testInterruptedDuringSerialisation$5((ChronicleQueue)queueWriter, interrupter));
            writerThread.start();
            writerThread.join();
            try (SingleChronicleQueue queue2 = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
                dump = this.cleanQueueDump(queue2.dump());
                Assert.assertEquals((String)"queue should be unchanged by the interrupted write", (Object)cleanedQueueDump, (Object)dump);
            }
            Assert.assertTrue((boolean)reader.readOne());
            Assert.assertEquals((long)1L, (long)names.size());
            Assert.assertEquals((Object)person1.name, names.get(0));
            Assert.assertFalse((boolean)reader.readOne());
            this.doWrite((ChronicleQueue)queueWriter, (proxy, queue) -> {
                try {
                    proxy.accept(thrower);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            });
            queue2 = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();
            var17_21 = null;
            try {
                dump = this.cleanQueueDump(queue2.dump());
                if (this.lazyIndexing) {
                    cleanedQueueDump = "--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY_LIGHT,\n  writePosition: [\n    442,\n    0\n  ],\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 475,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  recovery: !TimedStoreRecovery {\n    timeStamp: 0\n  },\n  deltaCheckpointInterval: 0,\n  lastIndexReplicated: -1,\n  sourceId: 0\n}\n# position: 442, header: 0\n--- !!data #binary\naccept: {\n  age: 40,\n  name: Terry\n}\n# position: 475, header: 0\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0\n]\n...\n\n";
                }
                Assert.assertEquals((String)"queue should be unchanged by the failed write", (Object)cleanedQueueDump, (Object)dump);
            }
            catch (Throwable dump2) {
                var17_21 = dump2;
                throw dump2;
            }
            finally {
                if (queue2 != null) {
                    if (var17_21 != null) {
                        try {
                            queue2.close();
                        }
                        catch (Throwable dump2) {
                            var17_21.addSuppressed(dump2);
                        }
                    } else {
                        queue2.close();
                    }
                }
            }
            Assert.assertFalse((boolean)reader.readOne());
            ExcerptAppender appender = queueWriter.acquireAppender().lazyIndexing(this.lazyIndexing);
            DocumentContext wd = appender.writingDocument();
            wd.rollbackOnClose();
            wd.close();
            dump = this.cleanQueueDump(queueWriter.dump());
            Assert.assertEquals((String)"queue should be unchanged by the failed write", (Object)cleanedQueueDump, (Object)dump);
            Assert.assertFalse((boolean)reader.readOne());
            this.doWrite((ChronicleQueue)queueWriter, (proxy, queue) -> proxy.accept(person2));
            Assert.assertTrue((boolean)reader.readOne());
            Assert.assertEquals((long)2L, (long)names.size());
            Assert.assertEquals((Object)person2.name, names.get(1));
            Assert.assertFalse((boolean)reader.readOne());
        }
    }

    private String cleanQueueDump(String from) {
        return from.replaceAll("# [0-9]+ bytes remaining$", "");
    }

    private void doWrite(ChronicleQueue queue, BiConsumer<PersonListener, ChronicleQueue> action) {
        ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
        PersonListener proxy = (PersonListener)appender.methodWriterBuilder(PersonListener.class).get();
        action.accept(proxy, queue);
    }

    @Ignore(value="store.writePosition() not set after we recover, but not trivial to fix. Problem only occurs rarely")
    @Test
    public void testSkipSafeLengthOverBlock() {
        File tmpDir = DirectoryUtils.tempDir("testSkipSafeLengthOverBlock");
        for (int i = 0; i < 8; ++i) {
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).timeoutMS(1L).build();){
                ExcerptAppender appender = queue.acquireAppender().lazyIndexing(this.lazyIndexing);
                DocumentContext dc = appender.writingDocument();
                dc.wire().write((CharSequence)"some").text("data");
                continue;
            }
        }
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().build();){
            ExcerptTailer tailer = queue.createTailer();
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertFalse((boolean)dc.isPresent());
            }
        }
    }

    @After
    public void checkMappedFiles() {
        MappedFile.checkMappedFiles();
    }

    private /* synthetic */ void lambda$testInterruptedDuringSerialisation$5(ChronicleQueue queueWriter, Person interrupter) {
        this.doWrite(queueWriter, (proxy, queue) -> proxy.accept(interrupter));
    }

    private class Person
    implements Marshallable {
        static final String INTERRUPT = "Arthur";
        static final String THROW = "Thrower";
        final int age;
        final String name;

        public Person(int age, String name) {
            this.age = age;
            this.name = name;
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write((CharSequence)"age").int32(this.age);
            if (INTERRUPT.equals(this.name)) {
                Thread.currentThread().interrupt();
            } else {
                if (THROW.equals(this.name)) {
                    throw new NullPointerException();
                }
                wire.write((CharSequence)"name").text(this.name);
            }
        }

        public String toString() {
            return "Person{age=" + this.age + ", name='" + this.name + '\'' + '}';
        }
    }

    private static interface PersonListener {
        public void accept(Person var1);
    }
}

