/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class RollCycleTest {
    @Test
    public void newRollCycleIgnored() throws Exception {
        File path = DirectoryUtils.tempDir("newRollCycleIgnored");
        SetTimeProvider timeProvider = new SetTimeProvider();
        ParallelQueueObserver observer = new ParallelQueueObserver((TimeProvider)timeProvider, path.toPath());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.fieldlessBinary((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.DAILY).timeProvider((TimeProvider)timeProvider).build();){
            ExcerptAppender appender = queue.acquireAppender();
            Thread thread = new Thread(observer);
            thread.start();
            observer.await();
            timeProvider.advanceMillis(TimeUnit.DAYS.toMillis(2L));
            appender.writeText((CharSequence)"Day 3 data");
            for (int i = 0; i < 5000 && observer.documentsRead != 1; ++i) {
                Thread.sleep(1L);
            }
            thread.interrupt();
        }
        Assert.assertEquals((long)1L, (long)observer.documentsRead);
        observer.queue.close();
    }

    @Test
    public void newRollCycleIgnored2() throws Exception {
        File path = DirectoryUtils.tempDir("newRollCycleIgnored2");
        SetTimeProvider timeProvider = new SetTimeProvider();
        ParallelQueueObserver observer = new ParallelQueueObserver((TimeProvider)timeProvider, path.toPath());
        int cyclesToWrite = 100;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.fieldlessBinary((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.DAILY).timeProvider((TimeProvider)timeProvider).build();){
            int i;
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"0");
            Thread thread = new Thread(observer);
            thread.start();
            observer.await();
            for (i = 1; i <= cyclesToWrite; ++i) {
                timeProvider.advanceMillis(TimeUnit.DAYS.toMillis(2L));
                appender.writeText((CharSequence)Integer.toString(i));
            }
            for (i = 0; i < 5000 && observer.documentsRead != 1 + cyclesToWrite; ++i) {
                Thread.sleep(1L);
            }
            thread.interrupt();
        }
        Assert.assertEquals((long)(1 + cyclesToWrite), (long)observer.documentsRead);
        observer.queue.close();
    }

    @Test
    public void testWriteToCorruptedFile() {
        File dir = DirectoryUtils.tempDir("testWriteToCorruptedFile");
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            long pos;
            Bytes bytes;
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write().text("hello world");
            }
            try (DocumentContext dc = appender.writingDocument();){
                bytes = dc.wire().bytes();
                pos = bytes.writePosition() - 4L;
            }
            bytes.writeInt(pos, Integer.MIN_VALUE);
            dc = appender.writingDocument();
            var9_15 = null;
            try {
                dc.wire().write().text("hello world 2");
            }
            catch (Throwable throwable) {
                var9_15 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var9_15 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var9_15.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = appender.writingDocument();
            var9_15 = null;
            try {
                dc.wire().write().text("hello world 3");
            }
            catch (Throwable throwable) {
                var9_15 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var9_15 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var9_15.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @After
    public void checkMappedFiles() {
        MappedFile.checkMappedFiles();
    }

    class ParallelQueueObserver
    implements Runnable,
    StoreFileListener {
        SingleChronicleQueue queue;
        CountDownLatch progressLatch;
        volatile int documentsRead;

        public ParallelQueueObserver(@NotNull TimeProvider timeProvider, Path path) {
            this.queue = SingleChronicleQueueBuilder.fieldlessBinary((File)path.toFile()).testBlockSize().rollCycle((RollCycle)RollCycles.DAILY).timeProvider(timeProvider).storeFileListener((StoreFileListener)this).build();
            this.documentsRead = 0;
            this.progressLatch = new CountDownLatch(1);
        }

        @Override
        public void run() {
            ExcerptTailer tailer = this.queue.createTailer();
            this.progressLatch.countDown();
            int lastDocId = -1;
            while (!Thread.currentThread().isInterrupted()) {
                String readText = tailer.readText();
                if (readText == null) continue;
                System.out.println("Read a document " + readText);
                ++this.documentsRead;
                int docId = Integer.parseInt(readText);
                Assert.assertTrue((docId == lastDocId + 1 ? 1 : 0) != 0);
                lastDocId = docId;
            }
        }

        public void await() throws Exception {
            this.progressLatch.await();
        }

        public int documentsRead() {
            return this.documentsRead;
        }

        public void onAcquired(int cycle, File file) {
            System.out.println("Acquiring " + file);
        }

        public void onReleased(int cycle, File file) {
            System.out.println("Releasing " + file);
        }
    }
}

