/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.queue.impl.single.TimedStoreRecovery;
import net.openhft.chronicle.wire.DocumentContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SingleChronicleQueueStoreTest {
    private static final int INDEX_SPACING = 4;
    private static final int RECORD_COUNT = 40;
    private static final RollCycles ROLL_CYCLE = RollCycles.DAILY;
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();

    @Test
    public void shouldPerformIndexing() throws Exception {
        AtomicLong clock = new AtomicLong(System.currentTimeMillis());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.tmpDir.newFolder()).testBlockSize().timeProvider(clock::get).rollCycle((RollCycle)ROLL_CYCLE).indexSpacing(4).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.lazyIndexing(false);
            SingleChronicleQueueStore wireStore = (SingleChronicleQueueStore)queue.storeForCycle(queue.cycle(), 0L, true);
            long[] indices = new long[40];
            for (int i = 0; i < 40; ++i) {
                try (DocumentContext ctx = appender.writingDocument();){
                    ctx.wire().getValueOut().int32(i);
                    continue;
                }
            }
            ExcerptTailer tailer = queue.createTailer();
            for (int i = 0; i < 40; ++i) {
                try (DocumentContext ctx = tailer.readingDocument();){
                    Assert.assertThat((String)("Expected record at index " + i), (Object)ctx.isPresent(), (Matcher)CoreMatchers.is((Object)true));
                    indices[i] = tailer.index();
                    continue;
                }
            }
            Field field = SingleChronicleQueueStore.class.getDeclaredField("recovery");
            field.setAccessible(true);
            TimedStoreRecovery recovery = (TimedStoreRecovery)field.get(wireStore);
            SCQIndexing indexing = wireStore.indexing;
            for (int i = 0; i < 40; ++i) {
                int startLinearScanCount = indexing.linearScanCount;
                Assert.assertThat((Object)indexing.moveToIndex0((StoreRecovery)recovery, (ExcerptContext)((SingleChronicleQueueExcerpts.StoreTailer)tailer), indices[i]), (Matcher)CoreMatchers.is((Object)ScanResult.FOUND));
                if (i % 4 == 0) {
                    Assert.assertThat((Object)indexing.linearScanCount, (Matcher)CoreMatchers.is((Object)startLinearScanCount));
                    continue;
                }
                Assert.assertThat((Object)indexing.linearScanCount, (Matcher)CoreMatchers.is((Object)(startLinearScanCount + 1)));
            }
        }
    }
}

