/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomCommon;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RandomDataInput
extends RandomCommon {
    public static final String[] charToString = RandomDataInput.createCharToString();

    @NotNull
    public static String[] createCharToString() {
        int i;
        String[] charToString = new String[256];
        charToString[0] = "\u0660";
        for (i = 1; i < 21; ++i) {
            charToString[i] = Character.toString((char)(i + 9351));
        }
        for (i = 32; i < 256; ++i) {
            charToString[i] = Character.toString((char)i);
        }
        for (i = 21; i < 32; ++i) {
            charToString[i] = "\\u00" + Integer.toHexString(i).toUpperCase();
        }
        for (i = 128; i < 160; ++i) {
            charToString[i] = "\\u00" + Integer.toHexString(i).toUpperCase();
        }
        return charToString;
    }

    default public int peekVolatileInt() throws BufferUnderflowException {
        return this.readVolatileInt(this.readPosition());
    }

    @ForceInline
    default public boolean readBoolean(long offset) throws BufferUnderflowException {
        return BytesUtil.byteToBoolean(this.readByte(offset));
    }

    public byte readByte(long var1) throws BufferUnderflowException;

    @ForceInline
    default public int readUnsignedByte(long offset) throws BufferUnderflowException {
        return this.readByte(offset) & 0xFF;
    }

    public int peekUnsignedByte(long var1) throws BufferUnderflowException;

    public short readShort(long var1) throws BufferUnderflowException;

    @ForceInline
    default public int readUnsignedShort(long offset) throws BufferUnderflowException {
        return this.readShort(offset) & 0xFFFF;
    }

    default public int readUnsignedInt24(long offset) throws BufferUnderflowException {
        return this.readUnsignedShort(offset) | this.readUnsignedByte(offset) << 16;
    }

    public int readInt(long var1) throws BufferUnderflowException;

    @ForceInline
    default public long readUnsignedInt(long offset) throws BufferUnderflowException {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    public long readLong(long var1) throws BufferUnderflowException;

    public float readFloat(long var1) throws BufferUnderflowException;

    public double readDouble(long var1) throws BufferUnderflowException;

    default public String printable(long offset) throws BufferUnderflowException {
        return charToString[this.readUnsignedByte(offset)];
    }

    public byte readVolatileByte(long var1) throws BufferUnderflowException;

    public short readVolatileShort(long var1) throws BufferUnderflowException;

    public int readVolatileInt(long var1) throws BufferUnderflowException;

    default public float readVolatileFloat(long offset) throws BufferUnderflowException {
        return Float.intBitsToFloat(this.readVolatileInt(offset));
    }

    public long readVolatileLong(long var1) throws BufferUnderflowException;

    default public double readVolatileDouble(long offset) throws BufferUnderflowException {
        return Double.longBitsToDouble(this.readVolatileLong(offset));
    }

    default public long parseLong(long offset) throws BufferUnderflowException {
        return BytesInternal.parseLong(this, offset);
    }

    public void nativeRead(long var1, long var3, long var5) throws BufferUnderflowException;

    default public int copyTo(@NotNull byte[] bytes) throws BufferUnderflowException {
        int len = (int)Math.min((long)bytes.length, this.readRemaining());
        for (int i = 0; i < len; ++i) {
            bytes[i] = this.readByte(this.start() + (long)i);
        }
        return len;
    }

    default public int copyTo(@NotNull ByteBuffer bb) throws BufferUnderflowException {
        int i;
        int pos = bb.position();
        int len = (int)Math.min((long)bb.remaining(), this.readRemaining());
        for (i = 0; i < len - 7; i += 8) {
            bb.putLong(pos + i, this.readLong(this.start() + (long)i));
        }
        while (i < len) {
            bb.put(pos + i, this.readByte(this.start() + (long)i));
            ++i;
        }
        return len;
    }

    default public long readIncompleteLong(long offset) {
        long l;
        long left = this.readLimit() - offset;
        try {
            if (left >= 8L) {
                return this.readLong(offset);
            }
            if (left == 4L) {
                return this.readInt(offset);
            }
            l = 0L;
            int remaining = (int)left;
            for (int i = 0; i < remaining; ++i) {
                l |= (long)this.readUnsignedByte(offset + (long)i) << i * 8;
            }
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
        return l;
    }

    public long realCapacity();

    default public int addAndGetInt(long offset, int adding) throws BufferUnderflowException {
        return BytesInternal.addAndGetInt(this, offset, adding);
    }

    default public long addAndGetLong(long offset, long adding) throws BufferUnderflowException {
        return BytesInternal.addAndGetLong(this, offset, adding);
    }

    default public float addAndGetFloat(long offset, float adding) throws BufferUnderflowException {
        return BytesInternal.addAndGetFloat(this, offset, adding);
    }

    default public double addAndGetDouble(long offset, double adding) throws BufferUnderflowException {
        return BytesInternal.addAndGetDouble(this, offset, adding);
    }

    @NotNull
    default public BytesStore subBytes(long start, long length) throws BufferUnderflowException {
        return BytesInternal.subBytes(this, start, length);
    }

    default public long findByte(byte stopByte) {
        return BytesInternal.findByte(this, stopByte);
    }

    default public <ACS extends Appendable & CharSequence> long readUtf8(long offset, @NotNull ACS sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException {
        AppendableUtil.setLength(sb, 0);
        long utfLen = this.readByte(offset++);
        if (utfLen < 0L) {
            long b;
            utfLen &= 0x7FL;
            int count = 7;
            while ((b = (long)this.readByte(offset++)) < 0L) {
                utfLen |= (b & 0x7FL) << count;
                count += 7;
            }
            if (b != 0L) {
                if (count > 56) {
                    throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
                }
                utfLen |= b << count;
            } else {
                if (count > 63) {
                    throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
                }
                utfLen ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (utfLen == -1L) {
            return offset ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int len = Maths.toUInt31(utfLen);
        BytesInternal.parseUtf8(this, offset, sb, len);
        return offset + utfLen;
    }

    default public <ACS extends Appendable & CharSequence> long readUtf8Limited(long offset, @NotNull ACS sb, int maxUtf8Len) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException, IllegalStateException {
        AppendableUtil.setLength(sb, 0);
        long utfLen = this.readByte(offset++);
        if (utfLen < 0L) {
            long b;
            utfLen &= 0x7FL;
            int count = 7;
            while ((b = (long)this.readByte(offset++)) < 0L) {
                utfLen |= (b & 0x7FL) << count;
                count += 7;
            }
            if (b != 0L) {
                if (count > 56) {
                    throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
                }
                utfLen |= b << count;
            } else {
                if (count > 63) {
                    throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
                }
                utfLen ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (utfLen == -1L) {
            return offset ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (utfLen > (long)maxUtf8Len) {
            throw new IllegalStateException("Attempted to read a char sequence of utf8 size " + utfLen + ", when only " + maxUtf8Len + " allowed");
        }
        BytesInternal.parseUtf8(this, offset, sb, (int)utfLen);
        return offset + utfLen;
    }

    @Nullable
    @net.openhft.chronicle.core.annotation.Nullable
    default public String readUtf8Limited(long offset, int maxUtf8Len) throws BufferUnderflowException, IORuntimeException, IllegalArgumentException, IllegalStateException {
        return BytesInternal.readUtf8(this, offset, maxUtf8Len);
    }

    default public boolean compareUtf8(long offset, @net.openhft.chronicle.core.annotation.Nullable CharSequence other) throws IORuntimeException {
        return BytesInternal.compareUtf8(this, offset, other);
    }

    @NotNull
    default public byte[] toByteArray() throws IllegalArgumentException {
        return BytesInternal.toByteArray(this);
    }

    default public long read(long offsetInRDI, byte[] bytes, int offset, int length) {
        try {
            int len = (int)Math.min((long)length, this.readLimit() - offsetInRDI);
            for (int i = 0; i < len; ++i) {
                bytes[offset + i] = this.readByte(offsetInRDI + (long)i);
            }
            return len;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public ByteBuffer toTemporaryDirectByteBuffer() throws IllegalArgumentException {
        int len = Maths.toUInt31(this.readRemaining());
        try {
            ByteBuffer bb = ByteBuffer.allocateDirect(len);
            this.copyTo(bb);
            bb.clear();
            return bb;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public int fastHash(long offset, int length) throws BufferUnderflowException {
        long hash = 0L;
        int i = 0;
        if (length >= 4) {
            hash = this.readInt(offset + (long)i);
            i += 4;
        }
        while (i < length - 3) {
            hash *= 1829709757L;
            hash += (long)this.readInt(offset + (long)i);
            i += 4;
        }
        if (i < length - 1) {
            hash *= 1829709757L;
            hash += (long)this.readShort(offset + (long)i);
            i += 2;
        }
        if (i < length) {
            hash += (long)this.readByte(offset + (long)i);
        }
        return (int)((hash *= -2057448229L) ^ hash >> 32);
    }
}

