/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.MethodWriterInterceptor;
import net.openhft.chronicle.bytes.MethodWriterInvocationHandler;
import net.openhft.chronicle.bytes.MethodWriterListener;
import net.openhft.chronicle.core.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class VanillaMethodWriterBuilder<T>
implements Supplier<T>,
MethodWriterBuilder<T> {
    private final List<Class> interfaces = new ArrayList<Class>();
    @NotNull
    private final MethodWriterInvocationHandler handler;
    private ClassLoader classLoader;
    private String genericEvent = "";

    public VanillaMethodWriterBuilder(@NotNull Class<T> tClass, @NotNull MethodWriterInvocationHandler handler) {
        this.interfaces.add(Closeable.class);
        this.interfaces.add(tClass);
        this.classLoader = tClass.getClassLoader();
        this.handler = handler;
    }

    @NotNull
    public MethodWriterBuilder<T> classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> addInterface(Class additionalClass) {
        this.interfaces.add(additionalClass);
        return this;
    }

    @Override
    @NotNull
    public MethodWriterBuilder<T> recordHistory(boolean recordHistory) {
        this.handler.recordHistory(recordHistory);
        return this;
    }

    @Override
    @NotNull
    public MethodWriterBuilder<T> methodWriterListener(MethodWriterListener methodWriterListener) {
        this.handler.methodWriterListener(methodWriterListener);
        return this;
    }

    @NotNull
    public MethodWriterBuilder<T> methodWriterInterceptor(MethodWriterInterceptor methodWriterInterceptor) {
        this.handler.methodWriterInterceptor(methodWriterInterceptor);
        return this;
    }

    @Override
    @NotNull
    public MethodWriterBuilder<T> onClose(Closeable closeable) {
        this.handler.onClose(closeable);
        return this;
    }

    @Override
    @NotNull
    public T build() {
        return this.get();
    }

    @Override
    @NotNull
    public T get() {
        Class[] interfacesArr = this.interfaces.toArray(new Class[this.interfaces.size()]);
        return (T)Proxy.newProxyInstance(this.classLoader, interfacesArr, (InvocationHandler)this.handler);
    }

    @Override
    public MethodWriterBuilder<T> genericEvent(String genericEvent) {
        this.handler.genericEvent(genericEvent);
        return this;
    }

    @Override
    public MethodWriterBuilder<T> useMethodIds(boolean useMethodIds) {
        this.handler.useMethodIds(useMethodIds);
        return this;
    }
}

