/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;

public class WriteDocumentContext
implements DocumentContext {
    protected Wire wire;
    protected long position = -1L;
    protected int tmpHeader;
    private int metaDataBit;

    public WriteDocumentContext(Wire wire) {
        this.wire = wire;
    }

    public void start(boolean metaData) {
        Bytes<?> bytes = this.wire().bytes();
        bytes.comment("msg-length");
        this.position = bytes.writePosition();
        this.metaDataBit = metaData ? 0x40000000 : 0;
        this.tmpHeader = this.metaDataBit | Integer.MIN_VALUE | 0;
        bytes.writeOrderedInt(this.tmpHeader);
    }

    @Override
    public boolean isMetaData() {
        return this.metaDataBit != 0;
    }

    @Override
    public void metaData(boolean metaData) {
        this.metaDataBit = metaData ? 0x40000000 : 0;
    }

    @Override
    public void close() {
        int length;
        Bytes<?> bytes = this.wire().bytes();
        long position1 = bytes.writePosition();
        long length0 = position1 - this.position - 4L;
        if (length0 > Integer.MAX_VALUE && bytes instanceof HexDumpBytes) {
            length0 = (int)length0;
        }
        if (!bytes.compareAndSwapInt(this.position, this.tmpHeader, length = this.metaDataBit | Wires.toIntU30(length0, "Document length %,d out of 30-bit int range."))) {
            throw new IllegalStateException("Header at " + this.position + " overwritten with " + Integer.toHexString(bytes.readInt(this.position)));
        }
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public Wire wire() {
        return this.wire;
    }

    protected long position() {
        return this.position;
    }

    @Override
    public long index() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int sourceId() {
        return -1;
    }

    @Override
    public boolean isNotComplete() {
        return true;
    }
}

