/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.core.values.IntValue;
import org.jetbrains.annotations.NotNull;

public class BinaryIntReference
extends AbstractReference
implements IntValue {
    @Override
    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException, BufferUnderflowException {
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        super.bytesStore(bytes, offset, length);
    }

    @Override
    public long maxSize() {
        return 4L;
    }

    @NotNull
    public String toString() {
        return this.bytes == null ? "bytes is null" : "value: " + this.getValue();
    }

    @Override
    public int getValue() {
        return this.bytes == null ? 0 : this.bytes.readInt(this.offset);
    }

    @Override
    public void setValue(int value) {
        this.bytes.writeInt(this.offset, value);
    }

    @Override
    public int getVolatileValue() {
        return this.bytes.readVolatileInt(this.offset);
    }

    @Override
    public void setOrderedValue(int value) {
        this.bytes.writeOrderedInt(this.offset, value);
    }

    @Override
    public int addValue(int delta) {
        return this.bytes.addAndGetInt(this.offset, delta);
    }

    @Override
    public int addAtomicValue(int delta) {
        return this.addValue(delta);
    }

    @Override
    public boolean compareAndSwapValue(int expected, int value) {
        return this.bytes.compareAndSwapInt(this.offset, expected, value);
    }
}

