/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.reader;

import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.reader.ChronicleReaderPlugin;
import net.openhft.chronicle.queue.reader.MessageToTextQueueEntryHandler;
import net.openhft.chronicle.queue.reader.MethodReaderQueueEntryHandler;
import net.openhft.chronicle.queue.reader.QueueEntryHandler;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public final class ChronicleReader {
    private static final long UNSET_VALUE = Long.MIN_VALUE;
    private final List<Pattern> inclusionRegex = new ArrayList<Pattern>();
    private final List<Pattern> exclusionRegex = new ArrayList<Pattern>();
    private final Pauser pauser = Pauser.balanced();
    private Path basePath;
    private long startIndex = Long.MIN_VALUE;
    private boolean tailInputSource = false;
    private long maxHistoryRecords = Long.MIN_VALUE;
    private boolean readOnly = true;
    private ChronicleReaderPlugin customPlugin;
    private Consumer<String> messageSink;
    private Function<ExcerptTailer, DocumentContext> pollMethod = ExcerptTailer::readingDocument;
    private WireType wireType = WireType.TEXT;
    private Supplier<QueueEntryHandler> entryHandlerFactory = () -> new MessageToTextQueueEntryHandler(this.wireType);
    private boolean displayIndex = true;

    private static boolean checkForMatches(List<Pattern> patterns, String text, boolean shouldBePresent) {
        for (Pattern pattern : patterns) {
            if (!shouldBePresent != pattern.matcher(text).find()) continue;
            return false;
        }
        return true;
    }

    private static boolean isSet(long configValue) {
        return configValue != Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        boolean retryLastOperation;
        long highestReachedIndex = 0L;
        boolean isFirstIteration = true;
        do {
            try (ChronicleQueue queue = this.createQueue();
                 QueueEntryHandler messageConverter = this.entryHandlerFactory.get();){
                boolean queueHasBeenModified;
                ExcerptTailer tailer = queue.createTailer();
                do {
                    long lastObservedTailIndex;
                    if (highestReachedIndex != 0L) {
                        tailer.moveToIndex(highestReachedIndex);
                    }
                    Bytes<ByteBuffer> textConversionTarget = Bytes.elasticByteBuffer();
                    try {
                        this.moveToSpecifiedPosition(queue, tailer, isFirstIteration);
                        lastObservedTailIndex = tailer.index();
                        while (!Thread.currentThread().isInterrupted()) {
                            DocumentContext dc = this.pollMethod.apply(tailer);
                            Throwable throwable = null;
                            try {
                                if (!dc.isPresent()) {
                                    if (this.tailInputSource) {
                                        this.pauser.pause();
                                    }
                                    break;
                                }
                                this.pauser.reset();
                                if (this.customPlugin == null) {
                                    messageConverter.accept(dc.wire(), text -> this.applyFiltersAndLog((String)text, tailer.index()));
                                    continue;
                                }
                                this.customPlugin.onReadDocument(dc);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (dc == null) continue;
                                if (throwable != null) {
                                    try {
                                        dc.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                dc.close();
                            }
                        }
                    }
                    finally {
                        textConversionTarget.release();
                        highestReachedIndex = tailer.index();
                        isFirstIteration = false;
                    }
                    queueHasBeenModified = this.queueHasBeenModifiedSinceLastCheck(lastObservedTailIndex, queue);
                    retryLastOperation = false;
                } while (this.tailInputSource || queueHasBeenModified);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof DateTimeParseException) {
                    retryLastOperation = true;
                    continue;
                }
                throw e;
            }
        } while (retryLastOperation);
    }

    ChronicleReader withReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public ChronicleReader withMessageSink(Consumer<String> messageSink) {
        this.messageSink = messageSink;
        return this;
    }

    public Consumer<String> messageSink() {
        return this.messageSink;
    }

    public ChronicleReader withBasePath(Path path) {
        this.basePath = path;
        return this;
    }

    public ChronicleReader withInclusionRegex(String regex) {
        this.inclusionRegex.add(Pattern.compile(regex));
        return this;
    }

    public ChronicleReader withExclusionRegex(String regex) {
        this.exclusionRegex.add(Pattern.compile(regex));
        return this;
    }

    public ChronicleReader withCustomPlugin(ChronicleReaderPlugin customPlugin) {
        this.customPlugin = customPlugin;
        return this;
    }

    public ChronicleReader withStartIndex(long index) {
        this.startIndex = index;
        return this;
    }

    public ChronicleReader tail() {
        this.tailInputSource = true;
        return this;
    }

    public ChronicleReader historyRecords(long maxHistoryRecords) {
        this.maxHistoryRecords = maxHistoryRecords;
        return this;
    }

    public ChronicleReader asMethodReader() {
        this.entryHandlerFactory = () -> new MethodReaderQueueEntryHandler(this.wireType);
        return this;
    }

    public ChronicleReader withWireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    public ChronicleReader suppressDisplayIndex() {
        this.displayIndex = false;
        return this;
    }

    ChronicleReader withDocumentPollMethod(Function<ExcerptTailer, DocumentContext> pollMethod) {
        this.pollMethod = pollMethod;
        return this;
    }

    private boolean queueHasBeenModifiedSinceLastCheck(long lastObservedTailIndex, ChronicleQueue queue) {
        long currentTailIndex = this.getCurrentTailIndex(queue);
        return currentTailIndex > lastObservedTailIndex;
    }

    private void moveToSpecifiedPosition(ChronicleQueue ic, ExcerptTailer tailer, boolean isFirstIteration) {
        if (ChronicleReader.isSet(this.startIndex) && isFirstIteration) {
            if (this.startIndex < ic.firstIndex()) {
                throw new IllegalArgumentException(String.format("startIndex %d is less than first index %d", this.startIndex, ic.firstIndex()));
            }
            this.messageSink.accept("Waiting for startIndex " + this.startIndex);
            while (!tailer.moveToIndex(this.startIndex)) {
                Jvm.pause(100L);
            }
        }
        if (ChronicleReader.isSet(this.maxHistoryRecords) && isFirstIteration) {
            tailer.toEnd();
            tailer.moveToIndex(Math.max(ic.firstIndex(), tailer.index() - this.maxHistoryRecords));
        } else if (this.tailInputSource && isFirstIteration) {
            tailer.toEnd();
        }
    }

    private long getCurrentTailIndex(ChronicleQueue queue) {
        return queue.createTailer().toEnd().index();
    }

    @NotNull
    private ChronicleQueue createQueue() {
        if (!Files.exists(this.basePath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Path %s does not exist", this.basePath));
        }
        return SingleChronicleQueueBuilder.binary(this.basePath.toFile()).readOnly(this.readOnly).build();
    }

    private void applyFiltersAndLog(String text, long index) {
        if ((this.inclusionRegex.isEmpty() || ChronicleReader.checkForMatches(this.inclusionRegex, text, true)) && (this.exclusionRegex.isEmpty() || ChronicleReader.checkForMatches(this.exclusionRegex, text, false))) {
            if (this.displayIndex) {
                this.messageSink.accept("0x" + Long.toHexString(index) + ": ");
            }
            this.messageSink.accept(text);
        }
    }
}

