/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.math.BigInteger;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.LongConverter;

public class Base95LongConverter
implements LongConverter {
    public static final Base95LongConverter INSTANCE = new Base95LongConverter();
    private static final int BASE = 95;
    private static final BigInteger BASE_BI = BigInteger.valueOf(95L);
    private static final BigInteger TWO_TO_64 = BigInteger.ONE.shiftLeft(64);

    @Override
    public long parse(CharSequence text) {
        long v = 0L;
        for (int i = 0; i < text.length(); ++i) {
            v = v * 95L + (long)text.charAt(i) - 32L + 1L;
        }
        return v;
    }

    @Override
    public void append(StringBuilder text, long value) {
        int start = text.length();
        if (value < 0L) {
            BigInteger bi = BigInteger.valueOf(value).add(TWO_TO_64);
            int v = bi.mod(BASE_BI).intValueExact();
            value = bi.divide(BASE_BI).longValueExact();
            text.append((char)(32 + v - 1));
        }
        while (value != 0L) {
            int v = (int)(value % 95L);
            value /= 95L;
            text.append((char)(32 + v - 1));
        }
        StringUtils.reverse(text, start);
    }
}

