/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.queue.impl.single.StoreTailer;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SCQTools {

    static final int MESSAGE_HISTORY_METHOD_ID = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static MessageHistory readHistory(@NotNull DocumentContext dc, MessageHistory history) {
        Wire wire = dc.wire();
        if (wire == null) {
            return null;
        }
        Object parent = wire.parent();
        wire.parent(null);
        try {
            Bytes<?> bytes = wire.bytes();
            byte code = bytes.readByte(bytes.readPosition());
            history.reset();
            MessageHistory messageHistory = code == -70 ? SCQTools.readHistoryFromBytes(wire, history) : SCQTools.readHistoryFromWire(wire, history);
            return messageHistory;
        }
        finally {
            wire.parent(parent);
        }
    }

    @Nullable
    private static MessageHistory readHistoryFromBytes(@NotNull Wire wire, MessageHistory history) {
        Bytes<?> bytes = wire.bytes();
        if (-1L != wire.readEventNumber()) {
            return null;
        }
        ((BytesMarshallable)((Object)history)).readMarshallable(bytes);
        return history;
    }

    @Nullable
    private static MessageHistory readHistoryFromWire(@NotNull Wire wire, MessageHistory history) {
        StringBuilder sb = StoreTailer.SBP.acquireStringBuilder();
        ValueIn valueIn = wire.read(sb);
        if (!"history".contentEquals(sb)) {
            return null;
        }
        valueIn.object(history, MessageHistory.class);
        return history;
    }
}

