/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import net.openhft.chronicle.core.time.LongTime;
import net.openhft.chronicle.wire.LongConverter;

public class NanoTimestampLongConverter
implements LongConverter {
    public static final NanoTimestampLongConverter INSTANCE = new NanoTimestampLongConverter();
    final DateTimeFormatter dtf = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();

    @Override
    public long parse(CharSequence text) {
        if (text == null || text.length() == 0) {
            return 0L;
        }
        try {
            if (text.length() > 4 && text.charAt(4) == '/') {
                text = text.toString().replace('/', '-');
            }
            TemporalAccessor parse = this.dtf.parse(text);
            long time = parse.getLong(ChronoField.EPOCH_DAY) * 86400000000000L;
            if (parse.isSupported(ChronoField.NANO_OF_DAY)) {
                time += parse.getLong(ChronoField.NANO_OF_DAY);
            } else if (parse.isSupported(ChronoField.MICRO_OF_DAY)) {
                time += parse.getLong(ChronoField.MICRO_OF_DAY) * 1000L;
            } else if (parse.isSupported(ChronoField.MILLI_OF_DAY)) {
                time += parse.getLong(ChronoField.MILLI_OF_DAY) * 1000000L;
            } else if (parse.isSupported(ChronoField.SECOND_OF_DAY)) {
                time += parse.getLong(ChronoField.SECOND_OF_DAY) * 1000000000L;
            }
            return time;
        }
        catch (DateTimeParseException dtpe) {
            try {
                long number = LongTime.toNanos(Long.parseLong(text.toString()));
                if (LongTime.isMicros(number)) {
                    System.out.println("In input data, replace " + text + " with " + this.asString(number));
                } else if (number != 0L) {
                    System.out.println("In input data, replace " + text + " with a real date.");
                }
                return number;
            }
            catch (NumberFormatException e) {
                throw dtpe;
            }
        }
    }

    @Override
    public void append(StringBuilder text, long value) {
        if (value <= 0L) {
            text.append(value);
            return;
        }
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(value / 1000000000L, (int)(value % 1000000000L), ZoneOffset.UTC);
        this.dtf.formatTo(ldt, text);
    }
}

