/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.ReadMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class MoveIndexAfterFailedTailerTest
extends QueueTestCommon {
    @Test
    public void test() {
        String basePath = OS.getTarget() + "/" + this.getClass().getSimpleName() + "-" + Time.uniqueId();
        SingleChronicleQueueBuilder myBuilder = SingleChronicleQueueBuilder.single((String)basePath).testBlockSize().timeProvider(System::currentTimeMillis).rollCycle((RollCycle)RollCycles.HOURLY);
        int messages = 10;
        try (SingleChronicleQueue myWrite = myBuilder.build();){
            this.write((ChronicleQueue)myWrite, messages);
        }
        var5_5 = null;
        try (SingleChronicleQueue myRead = myBuilder.build();){
            this.read((ChronicleQueue)myRead, messages);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    private void read(@NotNull ChronicleQueue aChronicle, int expected) {
        ExcerptTailer myTailer = aChronicle.createTailer();
        int myLast = RollCycles.HOURLY.toCycle(myTailer.toEnd().index());
        int myFirst = RollCycles.HOURLY.toCycle(myTailer.toStart().index());
        int myCycle = myFirst - 1;
        long myIndex = RollCycles.HOURLY.toIndex(myCycle, 0L);
        int count = 0;
        while (myCycle <= myLast) {
            if (myTailer.moveToIndex(myIndex)) {
                while (myTailer.readDocument(this.read())) {
                    ++count;
                }
            }
            myIndex = RollCycles.HOURLY.toIndex(++myCycle, 0L);
        }
        Assert.assertEquals((long)expected, (long)count);
    }

    private ReadMarshallable read() {
        return aMarshallable -> {
            byte[] myBytes = aMarshallable.read().bytes();
            if (myBytes != null) {
                Jvm.debug().on(this.getClass(), "Reading: " + new String(myBytes, StandardCharsets.UTF_8));
            }
        };
    }

    private void write(@NotNull ChronicleQueue aChronicle, int messages) {
        ExcerptAppender myAppender = aChronicle.acquireAppender();
        for (int myCount = 0; myCount < messages; ++myCount) {
            myAppender.writeDocument(aMarshallable -> aMarshallable.write().bytes(Long.toString(System.currentTimeMillis()).getBytes(StandardCharsets.UTF_8)));
        }
    }
}

