/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class TestDeleteQueueFile
extends ChronicleQueueTestBase {
    private static final int NUM_REPEATS = 10;
    private final Path tempQueueDir = this.getTmpDir().toPath();

    @Test
    public void testRefreshDirectoryListingWillUpdateFirstAndLastIndicesCorrectly() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, null);){
            Files.delete(Paths.get(queueWithCycleDetails.rollCycles.get((int)0).filename, new String[0]));
            Files.delete(Paths.get(queueWithCycleDetails.rollCycles.get((int)2).filename, new String[0]));
            SingleChronicleQueue queue = queueWithCycleDetails.queue;
            queue.refreshDirectoryListing();
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            Assert.assertEquals((Object)Long.toHexString(secondCycle.firstIndex), (Object)Long.toHexString(queue.firstIndex()));
            Assert.assertEquals((Object)Long.toHexString(secondCycle.lastIndex), (Object)Long.toHexString(queue.lastIndex()));
            ExcerptTailer excerptTailer2 = queue.createTailer();
            Assert.assertEquals((Object)Long.toHexString(secondCycle.firstIndex), (Object)Long.toHexString(excerptTailer2.index()));
            this.readText(excerptTailer2, "test2");
        }
    }

    @Test
    public void tailerToStartWorksInFaceOfDeletedStoreFile() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, null);){
            SingleChronicleQueue queue = queueWithCycleDetails.queue;
            RollCycleDetails firstCycle = queueWithCycleDetails.rollCycles.get(0);
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            RollCycleDetails thirdCycle = queueWithCycleDetails.rollCycles.get(2);
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
            Assert.assertEquals((Object)Long.toHexString(thirdCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
            Files.delete(Paths.get(firstCycle.filename, new String[0]));
            Assert.assertEquals((Object)Long.toHexString(secondCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
        }
    }

    @Ignore(value="still doesn't work")
    @Test
    public void tailerToStartFromStartWorksInFaceOfDeletedStoreFile() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, null);){
            SingleChronicleQueue queue = queueWithCycleDetails.queue;
            RollCycleDetails firstCycle = queueWithCycleDetails.rollCycles.get(0);
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            RollCycleDetails thirdCycle = queueWithCycleDetails.rollCycles.get(2);
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertEquals((Object)Long.toHexString(thirdCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
            Files.delete(Paths.get(firstCycle.filename, new String[0]));
            Assert.assertEquals((Object)Long.toHexString(secondCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
        }
    }

    @Test
    public void tailerToEndWorksInFaceOfDeletedStoreFile() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, null);){
            SingleChronicleQueue queue = queueWithCycleDetails.queue;
            RollCycleDetails firstCycle = queueWithCycleDetails.rollCycles.get(0);
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            RollCycleDetails thirdCycle = queueWithCycleDetails.rollCycles.get(2);
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertEquals((Object)Long.toHexString(thirdCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
            Files.delete(Paths.get(thirdCycle.filename, new String[0]));
            Assert.assertEquals((Object)Long.toHexString(secondCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
        }
    }

    @Test
    public void tailerToEndFromEndWorksInFaceOfDeletedStoreFile() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, null);){
            SingleChronicleQueue queue = queueWithCycleDetails.queue;
            RollCycleDetails firstCycle = queueWithCycleDetails.rollCycles.get(0);
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            RollCycleDetails thirdCycle = queueWithCycleDetails.rollCycles.get(2);
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
            Assert.assertEquals((Object)Long.toHexString(thirdCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
            Files.delete(Paths.get(thirdCycle.filename, new String[0]));
            Assert.assertEquals((Object)Long.toHexString(secondCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
        }
    }

    @Test
    public void firstAndLastIndexAreRefreshedAfterForceRefreshInterval() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, builder -> builder.forceDirectoryListingRefreshIntervalMs(250L));){
            SingleChronicleQueue queue = queueWithCycleDetails.queue;
            RollCycleDetails firstCycle = queueWithCycleDetails.rollCycles.get(0);
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            RollCycleDetails thirdCycle = queueWithCycleDetails.rollCycles.get(2);
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(tailer.toStart().index()));
            Assert.assertEquals((Object)Long.toHexString(thirdCycle.lastIndex + 1L), (Object)Long.toHexString(tailer.toEnd().index()));
            Files.delete(Paths.get(firstCycle.filename, new String[0]));
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(queue.firstIndex()));
            Assert.assertEquals((Object)Long.toHexString(firstCycle.firstIndex), (Object)Long.toHexString(queue.firstIndex()));
            Jvm.pause((long)260L);
            Assert.assertEquals((Object)Long.toHexString(secondCycle.firstIndex), (Object)Long.toHexString(queue.firstIndex()));
        }
    }

    @Test
    public void tailingThroughDeletedCyclesWillRefreshThenRetry_Writable() throws IOException {
        this.tailingThroughDeletedCyclesWillRefreshThenRetry(qwcd -> qwcd.queue);
    }

    @Test
    public void tailingThroughDeletedCyclesWillRefreshThenRetry_ReadOnly() throws IOException {
        this.tailingThroughDeletedCyclesWillRefreshThenRetry(qwcd -> SingleChronicleQueueBuilder.binary((String)qwcd.queue.fileAbsolutePath()).rollCycle((RollCycle)RollCycles.FAST_DAILY).readOnly(true).build());
    }

    public void tailingThroughDeletedCyclesWillRefreshThenRetry(Function<QueueWithCycleDetails, SingleChronicleQueue> queueCreator) throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (QueueWithCycleDetails queueWithCycleDetails = this.createQueueWithNRollCycles(3, null);
             SingleChronicleQueue queue = queueCreator.apply(queueWithCycleDetails);){
            RollCycleDetails firstCycle = queueWithCycleDetails.rollCycles.get(0);
            RollCycleDetails secondCycle = queueWithCycleDetails.rollCycles.get(1);
            RollCycleDetails thirdCycle = queueWithCycleDetails.rollCycles.get(2);
            ExcerptTailer tailer = queue.createTailer();
            Files.delete(Paths.get(firstCycle.filename, new String[0]));
            Files.delete(Paths.get(secondCycle.filename, new String[0]));
            Files.delete(Paths.get(thirdCycle.filename, new String[0]));
            int counter = 0;
            while (true) {
                DocumentContext documentContext = tailer.readingDocument();
                Throwable throwable = null;
                try {
                    if (!documentContext.isPresent()) break;
                    ++counter;
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (documentContext == null) continue;
                    if (throwable != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    documentContext.close();
                    continue;
                }
                break;
            }
            Assert.assertEquals((long)10L, (long)counter);
        }
    }

    private QueueWithCycleDetails createQueueWithNRollCycles(int numberOfCycles, Consumer<SingleChronicleQueueBuilder> builderConsumer) {
        SetTimeProvider timeProvider = new SetTimeProvider();
        QueueStoreFileListener listener = new QueueStoreFileListener();
        SingleChronicleQueueBuilder queueBuilder = SingleChronicleQueueBuilder.binary((Path)this.tempQueueDir.resolve("unitTestQueue")).rollCycle((RollCycle)RollCycles.FAST_DAILY).timeProvider((TimeProvider)timeProvider).storeFileListener((StoreFileListener)listener);
        if (builderConsumer != null) {
            builderConsumer.accept(queueBuilder);
        }
        SingleChronicleQueue queue = queueBuilder.build();
        ExcerptAppender appender = queue.acquireAppender();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)queue.firstIndex());
        List<RollCycleDetails> rollCycleDetails = IntStream.range(0, numberOfCycles).mapToObj(i -> {
            long firstIndexInCycle = this.writeTextAndReturnFirstIndex(appender, "test" + (i + 1));
            long lastIndexInCycle = appender.lastIndexAppended();
            timeProvider.advanceMillis(TimeUnit.DAYS.toMillis(1L));
            BackgroundResourceReleaser.releasePendingResources();
            return new RollCycleDetails(firstIndexInCycle, lastIndexInCycle, listener.lastFileAcquired.getAbsolutePath());
        }).collect(Collectors.toList());
        Assert.assertEquals((long)numberOfCycles, (long)rollCycleDetails.size());
        ExcerptTailer excerptTailer = queue.createTailer();
        for (int i2 = 0; i2 < numberOfCycles; ++i2) {
            this.readText(excerptTailer, "test" + (i2 + 1));
        }
        return new QueueWithCycleDetails(queue, rollCycleDetails);
    }

    private long writeTextAndReturnFirstIndex(ExcerptAppender appender, String text) {
        long firstIndex = -1L;
        for (int i = 0; i < 10; ++i) {
            appender.writeText((CharSequence)text);
            if (firstIndex >= 0L) continue;
            firstIndex = appender.lastIndexAppended();
        }
        return firstIndex;
    }

    private void readText(ExcerptTailer tailer, String text) {
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)text, (Object)tailer.readText());
        }
    }

    static final class QueueStoreFileListener
    implements StoreFileListener {
        private File lastFileAcquired;

        QueueStoreFileListener() {
        }

        public void onReleased(int cycle, File file) {
        }

        public void onAcquired(int cycle, File file) {
            System.out.println("onAcquired called cycle: " + cycle + ", file: " + file);
            this.lastFileAcquired = file;
        }
    }

    static class RollCycleDetails {
        final long firstIndex;
        final long lastIndex;
        final String filename;

        RollCycleDetails(long firstIndex, long lastIndex, String filename) {
            this.firstIndex = firstIndex;
            this.lastIndex = lastIndex;
            this.filename = filename;
        }
    }

    static class QueueWithCycleDetails
    extends AbstractCloseable {
        final SingleChronicleQueue queue;
        final List<RollCycleDetails> rollCycles;

        QueueWithCycleDetails(SingleChronicleQueue queue, List<RollCycleDetails> rollCycles) {
            this.queue = queue;
            this.rollCycles = rollCycles;
        }

        protected void performClose() throws IllegalStateException {
            Closeable.closeQuietly((Object)this.queue);
        }
    }
}

