/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import java.io.PrintStream;
import net.openhft.chronicle.jlbh.JLBH;
import net.openhft.chronicle.jlbh.JLBHOptions;
import net.openhft.chronicle.jlbh.JLBHTask;
import net.openhft.chronicle.jlbh.TeamCityHelper;

public class ByteArrayJLBHBenchmark
implements JLBHTask {
    private static final int MSG_THROUGHPUT = Integer.getInteger("throughput", 100000000);
    private static final int MSG_LENGTH = Integer.getInteger("length", 1000000);
    private static int iterations;
    static byte[] bytesArr1;
    static byte[] bytesArr3;
    private JLBH jlbh;

    public static void main(String[] args) {
        int throughput = MSG_THROUGHPUT / MSG_LENGTH;
        int warmUp = Math.min(20 * throughput, 12000);
        iterations = Math.min(15 * throughput, 100000);
        JLBHOptions lth = new JLBHOptions().warmUpIterations(warmUp).iterations(iterations).throughput(throughput).recordOSJitter(false).skipFirstRun(true).runs(5).jlbhTask((JLBHTask)new ByteArrayJLBHBenchmark());
        new JLBH(lth).start();
    }

    public void init(JLBH jlbh) {
        this.jlbh = jlbh;
    }

    public void run(long startTimeNS) {
        byte[] bytesArr2 = new byte[MSG_LENGTH];
        System.arraycopy(bytesArr1, 0, bytesArr2, 0, bytesArr1.length);
        System.arraycopy(bytesArr2, 0, bytesArr3, 0, bytesArr2.length);
        this.jlbh.sample(System.nanoTime() - startTimeNS);
    }

    public void complete() {
        TeamCityHelper.teamCityStatsLastRun((String)this.getClass().getSimpleName(), (JLBH)this.jlbh, (long)iterations, (PrintStream)System.out);
    }

    static {
        bytesArr1 = new byte[MSG_LENGTH];
        bytesArr3 = new byte[MSG_LENGTH];
    }
}

