/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.harness;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import org.jetbrains.annotations.NotNull;

public class WeeklyRollCycle
implements RollCycle {
    public static final WeeklyRollCycle INSTANCE = new WeeklyRollCycle("yyyyDDD", (int)TimeUnit.DAYS.toMillis(7L), 16384, 16);
    final String format;
    final int length;
    final int cycleShift;
    final int indexCount;
    final int indexSpacing;
    final long sequenceMask;

    WeeklyRollCycle(String format, int length, int indexCount, int indexSpacing) {
        this.format = format;
        this.length = length;
        this.indexCount = Maths.nextPower2((int)indexCount, (int)8);
        this.indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        this.cycleShift = Math.max(32, Maths.intLog2((long)indexCount) * 2 + Maths.intLog2((long)indexSpacing));
        this.sequenceMask = (1L << this.cycleShift) - 1L;
    }

    public String format() {
        return this.format;
    }

    public int lengthInMillis() {
        return this.length;
    }

    public int defaultIndexCount() {
        return this.indexCount;
    }

    public int defaultIndexSpacing() {
        return this.indexSpacing;
    }

    public int current(@NotNull TimeProvider time, long epoch) {
        return (int)((time.currentTimeMillis() - epoch) / (long)this.lengthInMillis());
    }

    public long toIndex(int cycle, long sequenceNumber) {
        return ((long)cycle << this.cycleShift) + (sequenceNumber & this.sequenceMask);
    }

    public long toSequenceNumber(long index) {
        return index & this.sequenceMask;
    }

    public int toCycle(long index) {
        return Maths.toUInt31((long)(index >> this.cycleShift));
    }

    public long maxMessagesPerCycle() {
        return RollCycles.maxMessagesPerCycle((long)this.indexCount, (int)this.indexSpacing);
    }
}

