/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.PretoucherState;
import org.junit.Assert;
import org.junit.Test;

public class PretoucherStateTest
extends QueueTestCommon {
    @Test
    public void pretouch() {
        long[] pos = new long[]{0L};
        StringBuilder record = new StringBuilder();
        DummyPretoucherState ps = new DummyPretoucherState(() -> {
            pos[0] = pos[0] + 4096L;
            return pos[0];
        }, 65536, record, () -> false);
        ps.pretouch(null);
        ps.pretouch(null);
        if (Jvm.isMacArm()) {
            Assert.assertEquals((Object)"debug none - Reset pretoucher to pos 4096 as the underlying MappedBytes changed.\ntouchPage 0 til 16 count 5\ndebug pretouch for only 0 of 5 min: 0 MB.\ndebug none: Advanced 4 KB, avg 13 KB between pretouch() and 4 KB while mapping of 0 KB \n", (Object)record.toString());
        } else {
            Assert.assertEquals((Object)"debug none - Reset pretoucher to pos 4096 as the underlying MappedBytes changed.\ntouchPage 1 til 17 count 17\ndebug pretouch for only 0 of 17 min: 0 MB.\ndebug none: Advanced 4 KB, avg 4 KB between pretouch() and 4 KB while mapping of 0 KB \n", (Object)record.toString());
        }
    }

    @Test
    public void pretouchLeap() {
        long[] pos = new long[]{0x100000L};
        StringBuilder record = new StringBuilder();
        DummyPretoucherState ps = new DummyPretoucherState(() -> {
            pos[0] = pos[0] + 4096L;
            return pos[0];
        }, 16384, record, () -> true);
        ps.pretouch(null);
        for (int i = 0; i < 8; ++i) {
            ps.pretouch(null);
            pos[0] = pos[0] + 57344L;
        }
        ps.pretouch(null);
        if (Jvm.isMacArm()) {
            Assert.assertEquals((Object)"debug none - Reset pretoucher to pos 1052672 as the underlying MappedBytes changed.\ntouchPage 256 til 268 count 4\ndebug none: Advanced 4 KB, avg 13 KB between pretouch() and 4 KB while mapping of 64 KB \ntouchPage 272 til 296 count 7\ndebug none: Advanced 64 KB, avg 25 KB between pretouch() and 4 KB while mapping of 112 KB \ntouchPage 300 til 324 count 7\ndebug none: Advanced 64 KB, avg 35 KB between pretouch() and 4 KB while mapping of 112 KB \ntouchPage 328 til 348 count 6\ndebug none: Advanced 64 KB, avg 42 KB between pretouch() and 4 KB while mapping of 96 KB \ntouchPage 352 til 368 count 5\ndebug none: Advanced 64 KB, avg 47 KB between pretouch() and 4 KB while mapping of 80 KB \ntouchPage 372 til 388 count 5\ndebug none: Advanced 64 KB, avg 51 KB between pretouch() and 4 KB while mapping of 80 KB \ntouchPage 392 til 408 count 5\ndebug none: Advanced 64 KB, avg 54 KB between pretouch() and 4 KB while mapping of 80 KB \ntouchPage 412 til 424 count 4\ndebug none: Advanced 64 KB, avg 57 KB between pretouch() and 4 KB while mapping of 64 KB \ntouchPage 428 til 444 count 5\ndebug none: Advanced 64 KB, avg 58 KB between pretouch() and 4 KB while mapping of 80 KB \n", (Object)record.toString());
        } else {
            Assert.assertEquals((Object)"debug none - Reset pretoucher to pos 1052672 as the underlying MappedBytes changed.\ntouchPage 257 til 261 count 5\ndebug none: Advanced 4 KB, avg 4 KB between pretouch() and 4 KB while mapping of 20 KB \ntouchPage 262 til 292 count 31\ndebug none: Advanced 64 KB, avg 19 KB between pretouch() and 4 KB while mapping of 124 KB \ntouchPage 293 til 320 count 28\ndebug none: Advanced 64 KB, avg 30 KB between pretouch() and 4 KB while mapping of 112 KB \ntouchPage 321 til 344 count 24\ndebug none: Advanced 64 KB, avg 38 KB between pretouch() and 4 KB while mapping of 96 KB \ntouchPage 345 til 367 count 23\ndebug none: Advanced 64 KB, avg 45 KB between pretouch() and 4 KB while mapping of 92 KB \ntouchPage 368 til 387 count 20\ndebug none: Advanced 64 KB, avg 49 KB between pretouch() and 4 KB while mapping of 80 KB \ntouchPage 388 til 407 count 20\ndebug none: Advanced 64 KB, avg 53 KB between pretouch() and 4 KB while mapping of 80 KB \ntouchPage 408 til 425 count 18\ndebug none: Advanced 64 KB, avg 55 KB between pretouch() and 4 KB while mapping of 72 KB \ntouchPage 426 til 443 count 18\ndebug none: Advanced 64 KB, avg 57 KB between pretouch() and 4 KB while mapping of 72 KB \n", (Object)record.toString());
        }
    }

    @Test
    public void pretouchLongBreak() {
        long[] pos = new long[]{0L};
        StringBuilder record = new StringBuilder();
        DummyPretoucherState ps = new DummyPretoucherState(() -> {
            pos[0] = pos[0] + 2048L;
            return pos[0];
        }, 16384, record, () -> true);
        for (int i = 0; i <= 10; ++i) {
            record.append("pos: ").append(pos[0]).append(", i:").append(i).append("\n");
            ps.pretouch(null);
        }
        if (Jvm.isMacArm()) {
            Assert.assertEquals((Object)"pos: 0, i:0\ndebug none - Reset pretoucher to pos 2048 as the underlying MappedBytes changed.\npos: 2048, i:1\ntouchPage 0 til 12 count 4\ndebug none: Advanced 2 KB, avg 12 KB between pretouch() and 2 KB while mapping of 64 KB \npos: 6144, i:2\npos: 8192, i:3\npos: 10240, i:4\npos: 12288, i:5\npos: 14336, i:6\npos: 16384, i:7\npos: 18432, i:8\npos: 20480, i:9\npos: 22528, i:10\n", (Object)record.toString());
        } else {
            Assert.assertEquals((Object)"pos: 0, i:0\ndebug none - Reset pretoucher to pos 2048 as the underlying MappedBytes changed.\npos: 2048, i:1\ntouchPage 0 til 4 count 5\ndebug none: Advanced 2 KB, avg 3 KB between pretouch() and 2 KB while mapping of 20 KB \npos: 6144, i:2\ntouchPage 5 til 5 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 10240, i:3\ntouchPage 6 til 6 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 14336, i:4\ntouchPage 7 til 7 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 18432, i:5\ntouchPage 8 til 8 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 22528, i:6\ntouchPage 9 til 9 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 26624, i:7\ntouchPage 10 til 10 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 30720, i:8\ntouchPage 11 til 11 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 34816, i:9\ntouchPage 12 til 12 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \npos: 38912, i:10\ntouchPage 13 til 13 count 1\ndebug none: Advanced 4 KB, avg 3 KB between pretouch() and 2 KB while mapping of 4 KB \n", (Object)record.toString());
        }
    }

    class DummyPretoucherState
    extends PretoucherState {
        private final BooleanSupplier touched;
        StringBuilder record;
        boolean first;
        private long last;

        DummyPretoucherState(LongSupplier posSupplier, int headRoom, StringBuilder record, BooleanSupplier touched) {
            super(posSupplier, headRoom);
            this.first = true;
            this.record = record;
            this.touched = touched;
        }

        protected void debug(String message) {
            this.record.append("debug ").append(message).append("\n");
        }

        protected boolean touchPage(MappedBytes bytes, long offset) {
            if (this.first) {
                this.record.append("touchPage ").append(offset / 4096L);
                this.first = false;
            }
            this.last = offset;
            return this.touched.getAsBoolean();
        }

        protected void onTouched(int count) {
            this.record.append(" til ").append(this.last / 4096L).append(" count ").append(count).append("\n");
            this.first = true;
        }
    }
}

