/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import org.junit.Assert;
import org.junit.Test;

public final class QueueEpochTest
extends ChronicleQueueTestBase {
    private static final boolean DEBUG = false;
    private static final long MIDNIGHT_UTC_BASE_TIME = 1504569600000L;
    private static final long UTC_OFFSET = TimeUnit.HOURS.toMillis(21L) + TimeUnit.MINUTES.toMillis(15L);
    private static final long ROLL_TIME = 1504569600000L + UTC_OFFSET;
    private static final long TEN_MINUTES_BEFORE_ROLL_TIME = ROLL_TIME - TimeUnit.MINUTES.toMillis(10L);
    private static final long FIVE_MINUTES_BEFORE_ROLL_TIME = ROLL_TIME - TimeUnit.MINUTES.toMillis(5L);
    private static final long ONE_SECOND_BEFORE_ROLL_TIME = ROLL_TIME - TimeUnit.SECONDS.toMillis(1L);
    private static final long ONE_SECOND_AFTER_ROLL_TIME = ROLL_TIME + TimeUnit.SECONDS.toMillis(1L);
    private static final long ONE_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final RollCycle DAILY_ROLL = RollCycles.DAILY;
    private long currentTime;

    private static void logDebug(String format, Object ... args) {
    }

    @Test
    public void shouldRollQueueFilesAccordingToUtcOffset() {
        QueueEpochTest.logDebug("UTC offset is %dms%n", UTC_OFFSET);
        File queueDir = this.getTmpDir();
        CapturingStoreFileListener fileListener = new CapturingStoreFileListener();
        this.setCurrentTime(1504569600000L);
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)queueDir).rollTime(LocalTime.of(21, 15), (ZoneId)ZoneOffset.UTC).timeProvider(this::getCurrentTime).storeFileListener((StoreFileListener)fileListener).rollCycle(DAILY_ROLL).build();){
            QueueEpochTest.logDebug("Queue epoch offset is %d%n", queue.epoch());
            ExcerptAppender appender = queue.acquireAppender();
            TestEvent eventWriter = (TestEvent)appender.methodWriter(TestEvent.class, new Class[0]);
            this.setCurrentTime(TEN_MINUTES_BEFORE_ROLL_TIME);
            eventWriter.setOrGetEvent(Long.toString(TEN_MINUTES_BEFORE_ROLL_TIME));
            this.setCurrentTime(FIVE_MINUTES_BEFORE_ROLL_TIME);
            eventWriter.setOrGetEvent(Long.toString(FIVE_MINUTES_BEFORE_ROLL_TIME));
            this.setCurrentTime(ONE_SECOND_BEFORE_ROLL_TIME);
            eventWriter.setOrGetEvent(Long.toString(ONE_SECOND_BEFORE_ROLL_TIME));
            Assert.assertEquals((long)0L, (long)fileListener.numberOfRollEvents());
            this.setCurrentTime(ONE_SECOND_AFTER_ROLL_TIME);
            eventWriter.setOrGetEvent(Long.toString(ONE_SECOND_AFTER_ROLL_TIME));
            Assert.assertEquals((long)1L, (long)fileListener.numberOfRollEvents());
            this.setCurrentTime(ONE_SECOND_BEFORE_ROLL_TIME + ONE_DAY);
            eventWriter.setOrGetEvent(Long.toString(ONE_SECOND_BEFORE_ROLL_TIME + ONE_DAY));
            Assert.assertEquals((long)1L, (long)fileListener.numberOfRollEvents());
            this.setCurrentTime(ONE_SECOND_AFTER_ROLL_TIME + ONE_DAY);
            eventWriter.setOrGetEvent(Long.toString(ONE_SECOND_AFTER_ROLL_TIME + ONE_DAY));
            Assert.assertEquals((long)2L, (long)fileListener.numberOfRollEvents());
        }
    }

    private long getCurrentTime() {
        return this.currentTime;
    }

    private void setCurrentTime(long currentTime) {
        QueueEpochTest.logDebug("Setting current time to %s%n", Instant.ofEpochMilli(currentTime));
        this.currentTime = currentTime;
    }

    private final class CapturingStoreFileListener
    implements StoreFileListener {
        private int numberOfRollEvents = 0;

        private CapturingStoreFileListener() {
        }

        public void onAcquired(int cycle, File file) {
            this.logFileAction(cycle, file, "acquired");
        }

        public void onReleased(int cycle, File file) {
            this.logFileAction(cycle, file, "released");
            ++this.numberOfRollEvents;
        }

        int numberOfRollEvents() {
            BackgroundResourceReleaser.releasePendingResources();
            return this.numberOfRollEvents;
        }

        private void logFileAction(int cycle, File file, String action) {
            QueueEpochTest.logDebug("%s file %s for cycle %d at %s%n", new Object[]{action, file.getName(), cycle, Instant.ofEpochMilli(QueueEpochTest.this.getCurrentTime())});
        }
    }

    @FunctionalInterface
    static interface TestEvent {
        public void setOrGetEvent(String var1);
    }
}

