/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.ref.BinaryTwoLongReference;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.RollCycleEncodeSequence;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RollCycleEncodeSequenceTest
extends QueueTestCommon {
    private final BinaryTwoLongReference longValue = new BinaryTwoLongReference();
    private final RollCycleEncodeSequence rollCycleEncodeSequence;
    private final Bytes<ByteBuffer> bytes = Bytes.elasticByteBuffer();

    public RollCycleEncodeSequenceTest(RollCycles cycle) {
        this.longValue.bytesStore(this.bytes, 0L, 16L);
        this.rollCycleEncodeSequence = new RollCycleEncodeSequence((LongValue)this.longValue, cycle.defaultIndexCount(), cycle.defaultIndexSpacing());
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({RollCycles.DAILY}, {RollCycles.DEFAULT}, {RollCycles.HOURLY}, {RollCycles.MINUTELY}, {RollCycles.HUGE_DAILY});
    }

    @Override
    public void preAfter() {
        this.longValue.close();
        this.bytes.releaseLast();
    }

    @Test
    public void forWritePosition() {
        this.longValue.setOrderedValue(1L);
        this.longValue.setOrderedValue2(2L);
        long forWritePosition = 2147601492L;
        long sequence = this.rollCycleEncodeSequence.getSequence(forWritePosition);
        Assert.assertEquals((long)Long.MIN_VALUE, (long)sequence);
    }

    @Test
    public void setGet() {
        int sequenceInitial = 11;
        int position = 262788;
        this.rollCycleEncodeSequence.setSequence((long)sequenceInitial, (long)position);
        long sequence = this.rollCycleEncodeSequence.getSequence((long)position);
        Assert.assertEquals((long)sequenceInitial, (long)sequence);
    }

    @Test
    public void setGetPositionNeedsMasking() {
        int sequenceInitial = 11;
        long position = 1250999896491L;
        this.rollCycleEncodeSequence.setSequence((long)sequenceInitial, position);
        long sequence = this.rollCycleEncodeSequence.getSequence(position);
        Assert.assertEquals((long)sequenceInitial, (long)sequence);
    }

    @Test
    public void setGetPositionMinus1() {
        int sequenceInitial = 11;
        long position = 0xFFFFFFFFFFFFL;
        this.rollCycleEncodeSequence.setSequence((long)sequenceInitial, position);
        long sequence = this.rollCycleEncodeSequence.getSequence(position);
        Assert.assertEquals((long)sequenceInitial, (long)sequence);
    }
}

