/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class RollCycleTest
extends ChronicleQueueTestBase {
    @Test
    public void newRollCycleIgnored() throws InterruptedException {
        File path = this.getTmpDir();
        SetTimeProvider timeProvider = new SetTimeProvider();
        ParallelQueueObserver observer = new ParallelQueueObserver((TimeProvider)timeProvider, path.toPath());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.fieldlessBinary((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.DEFAULT).timeProvider((TimeProvider)timeProvider).build();){
            ExcerptAppender appender = queue.acquireAppender();
            Thread thread = new Thread(observer);
            thread.start();
            observer.await();
            timeProvider.advanceMillis(TimeUnit.DAYS.toMillis(2L));
            appender.writeText((CharSequence)"0");
            for (int i = 0; i < 5000 && observer.documentsRead != 1; ++i) {
                timeProvider.advanceMicros(100L);
                Thread.sleep(1L);
            }
            thread.interrupt();
        }
        Assert.assertEquals((long)1L, (long)observer.documentsRead);
        observer.queue.close();
    }

    @Test
    public void newRollCycleIgnored2() throws InterruptedException {
        File path = this.getTmpDir();
        SetTimeProvider timeProvider = new SetTimeProvider();
        ParallelQueueObserver observer = new ParallelQueueObserver((TimeProvider)timeProvider, path.toPath());
        int cyclesToWrite = 100;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.fieldlessBinary((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.DEFAULT).timeProvider((TimeProvider)timeProvider).build();){
            int i;
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"0");
            Thread thread = new Thread(observer);
            thread.start();
            observer.await();
            for (i = 1; i <= cyclesToWrite; ++i) {
                timeProvider.advanceMillis(TimeUnit.DAYS.toMillis(2L));
                appender.writeText((CharSequence)Integer.toString(i));
            }
            for (i = 0; i < 5000 && observer.documentsRead != 1 + cyclesToWrite; ++i) {
                Thread.sleep(1L);
            }
            thread.interrupt();
        }
        Assert.assertEquals((long)(1 + cyclesToWrite), (long)observer.documentsRead);
        observer.queue.close();
    }

    @After
    public void clearInterrupt() {
        Thread.interrupted();
    }

    class ParallelQueueObserver
    implements Runnable,
    StoreFileListener {
        ChronicleQueue queue;
        CountDownLatch progressLatch;
        volatile int documentsRead;

        public ParallelQueueObserver(@NotNull TimeProvider timeProvider, Path path) {
            this.queue = SingleChronicleQueueBuilder.fieldlessBinary((File)path.toFile()).testBlockSize().rollCycle((RollCycle)RollCycles.DEFAULT).timeProvider(timeProvider).storeFileListener((StoreFileListener)this).build();
            this.documentsRead = 0;
            this.progressLatch = new CountDownLatch(1);
        }

        @Override
        public void run() {
            ExcerptTailer tailer = this.queue.createTailer();
            this.progressLatch.countDown();
            int lastDocId = -1;
            while (!Thread.currentThread().isInterrupted()) {
                String readText = tailer.readText();
                if (readText == null) continue;
                ++this.documentsRead;
                int docId = Integer.parseInt(readText);
                Assert.assertEquals((long)docId, (long)(lastDocId + 1));
                lastDocId = docId;
            }
        }

        public void await() throws InterruptedException {
            this.progressLatch.await();
        }

        public int documentsRead() {
            return this.documentsRead;
        }

        public void onAcquired(int cycle, File file) {
        }

        public void onReleased(int cycle, File file) {
        }
    }
}

