/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.jira;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.TestKey;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Queue28Test
extends ChronicleQueueTestBase {
    private final WireType wireType;

    public Queue28Test(WireType wireType) {
        this.wireType = wireType;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{WireType.BINARY}});
    }

    @Test
    public void test() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder((File)dir, (WireType)this.wireType).testBlockSize().build();){
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertFalse((boolean)tailer.readDocument(r -> r.read((WireKey)TestKey.test).int32()));
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument(w -> w.write((WireKey)TestKey.test).int32(1));
            Jvm.pause((long)100L);
            Assert.assertTrue((boolean)tailer.readDocument(r -> r.read((WireKey)TestKey.test).int32()));
        }
    }
}

