/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.reader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.reader.ChronicleReader;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class RollEOFTest
extends ChronicleQueueTestBase {
    private static final ReferenceOwner test = ReferenceOwner.temporary((String)"test");

    @Nullable
    static SingleChronicleQueueStore loadStore(@NotNull Wire wire) {
        StringBuilder eventName = new StringBuilder();
        wire.readEventName(eventName);
        if (eventName.toString().equals(MetaDataKeys.header.name())) {
            SingleChronicleQueueStore store = (SingleChronicleQueueStore)wire.read().typedMarshallable();
            if (store == null) {
                throw new IllegalArgumentException("Unable to load wire store");
            }
            return store;
        }
        Jvm.warn().on(RollEOFTest.class, "Unable to load store file from input. Queue file may be corrupted.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testRollWritesEOF() throws IOException {
        Assume.assumeFalse((String)"Read-only mode is not supported on Windows", (boolean)OS.isWindows());
        File path = this.getTmpDir();
        try {
            path.mkdirs();
            SetTimeProvider timeProvider = new SetTimeProvider();
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1);
            timeProvider.currentTimeMillis(cal.getTimeInMillis());
            this.createQueueAndWriteData((TimeProvider)timeProvider, path);
            Assert.assertEquals((long)1L, (long)this.getNumberOfQueueFiles(path));
            timeProvider.currentTimeMillis(System.currentTimeMillis());
            this.createQueueAndWriteData((TimeProvider)timeProvider, path);
            Assert.assertEquals((long)2L, (long)this.getNumberOfQueueFiles(path));
            LinkedList l = new LinkedList();
            new ChronicleReader().withMessageSink(l::add).withBasePath(path.toPath()).execute();
            Assert.assertEquals((long)4L, (long)l.size());
        }
        finally {
            IOTools.deleteDirWithFiles((File)path, (int)20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testRollWithoutEOFDoesntBlowup() throws IOException {
        Assume.assumeFalse((String)"Read-only mode is not supported on Windows", (boolean)OS.isWindows());
        File path = this.getTmpDir();
        try {
            path.mkdirs();
            SetTimeProvider timeProvider = new SetTimeProvider();
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1);
            timeProvider.currentTimeMillis(cal.getTimeInMillis());
            this.createQueueAndWriteData((TimeProvider)timeProvider, path);
            Assert.assertEquals((long)1L, (long)this.getNumberOfQueueFiles(path));
            timeProvider.currentTimeMillis(System.currentTimeMillis());
            this.createQueueAndWriteData((TimeProvider)timeProvider, path);
            Assert.assertEquals((long)2L, (long)this.getNumberOfQueueFiles(path));
            Optional<Path> firstQueueFile = Files.list(path.toPath()).filter(p -> p.toString().endsWith(".cq4")).sorted().findFirst();
            Assert.assertTrue((boolean)firstQueueFile.isPresent());
            this.removeEOF(firstQueueFile.get());
            LinkedList l = new LinkedList();
            new ChronicleReader().withMessageSink(l::add).withBasePath(path.toPath()).execute();
            Assert.assertEquals((long)4L, (long)l.size());
        }
        finally {
            IOTools.deleteDirWithFiles((File)path, (int)20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testRollWithoutEOF() throws IOException {
        File path = this.getTmpDir();
        try {
            path.mkdirs();
            SetTimeProvider timeProvider = new SetTimeProvider();
            Calendar cal = Calendar.getInstance();
            cal.add(5, -3);
            timeProvider.currentTimeMillis(cal.getTimeInMillis());
            this.createQueueAndWriteData((TimeProvider)timeProvider, path);
            Assert.assertEquals((long)1L, (long)this.getNumberOfQueueFiles(path));
            timeProvider.currentTimeMillis(System.currentTimeMillis());
            this.createQueueAndWriteData((TimeProvider)timeProvider, path);
            Assert.assertEquals((long)2L, (long)this.getNumberOfQueueFiles(path));
            Optional<Path> firstQueueFile = Files.list(path.toPath()).filter(p -> p.toString().endsWith(".cq4")).sorted().findFirst();
            Assert.assertTrue((boolean)firstQueueFile.isPresent());
            this.removeEOF(firstQueueFile.get());
            LinkedList l = new LinkedList();
            new ChronicleReader().withMessageSink(l::add).withBasePath(path.toPath()).withReadOnly(false).execute();
            Assert.assertEquals((long)4L, (long)l.size());
        }
        finally {
            IOTools.deleteDirWithFiles((File)path, (int)20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEOF(Path path) throws IOException {
        long blockSize = 65536L;
        long chunkSize = OS.pageAlign((long)blockSize);
        long overlapSize = OS.pageAlign((long)(blockSize / 4L));
        MappedBytes mappedBytes = MappedBytes.mappedBytes((File)path.toFile(), (long)chunkSize, (long)overlapSize, (boolean)false);
        mappedBytes.reserve(test);
        try {
            Wire wire = (Wire)WireType.BINARY_LIGHT.apply((Object)mappedBytes);
            Bytes bytes = wire.bytes();
            bytes.readLimitToCapacity();
            bytes.readSkip(4L);
            try (SingleChronicleQueueStore qs = RollEOFTest.loadStore(wire);){
                Assert.assertNotNull((Object)qs);
                long l = qs.writePosition();
                long len = Wires.lengthOf((int)bytes.readVolatileInt(l));
                long eofOffset = l + len + 4L;
                bytes.writePosition(eofOffset);
                bytes.writeInt(0);
            }
        }
        finally {
            mappedBytes.release(test);
        }
    }

    private long getNumberOfQueueFiles(File path) throws IOException {
        return this.getQueueFilesStream(path).count();
    }

    private Stream<Path> getQueueFilesStream(File path) throws IOException {
        return Files.list(path.toPath()).filter(p -> p.toString().endsWith(".cq4"));
    }

    private void createQueueAndWriteData(TimeProvider timeProvider, File path) {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).timeProvider(timeProvider).build();){
            ExcerptAppender excerptAppender = queue.acquireAppender();
            try (DocumentContext dc = excerptAppender.writingDocument(false);){
                dc.wire().write((CharSequence)"test").int64(0L);
            }
        }
    }
}

