/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.writer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.Mocker;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.internal.writer.ChronicleWriter;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class ChronicleWriterTest
extends QueueTestCommon {
    private static final String METHOD_NAME = "doit";
    private final String cw1 = IOTools.urlFor((ClassLoader)this.getClass().getClassLoader(), (String)"chronicle-writer1.yaml").getPath();
    private final String cw2 = IOTools.urlFor((ClassLoader)this.getClass().getClassLoader(), (String)"chronicle-writer2.yaml").getPath();
    private final String cw3 = IOTools.urlFor((ClassLoader)this.getClass().getClassLoader(), (String)"chronicle-writer3.yaml").getPath();
    private final File dir = IOTools.createTempFile((String)this.getClass().getSimpleName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testWireMarshallingMapAndDTO() throws IOException {
        ChronicleWriter chronicleWriter = this.chronicleWriter(null, this.cw1, this.cw2);
        chronicleWriter.execute();
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.dir).build();){
            StringBuilder sb = new StringBuilder();
            Object[] objectArray = new Object[1];
            objectArray[0] = Mocker.intercepting(MyInterface.class, (String)"*", sb::append);
            @NotNull MethodReader mr = queue.createTailer().methodReader(objectArray);
            Assert.assertTrue((boolean)mr.readOne());
            Assert.assertTrue((boolean)mr.readOne());
            Assert.assertFalse((boolean)mr.readOne());
            Assert.assertEquals((Object)"*doit[!net.openhft.chronicle.queue.internal.writer.ChronicleWriterTest$DTO {\n  age: 19,\n  name: Henry\n}\n]*doit[!net.openhft.chronicle.queue.internal.writer.ChronicleWriterTest$DTO {\n  age: 42,\n  name: Percy\n}\n]", (Object)sb.toString());
        }
        finally {
            IOTools.deleteDirWithFiles((File)this.dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testWireMarshallingWithInterface() throws IOException {
        ChronicleWriter chronicleWriter = this.chronicleWriter(MyInterface.class.getTypeName(), this.cw2);
        chronicleWriter.execute();
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.dir).build();){
            StringBuilder sb = new StringBuilder();
            Object[] objectArray = new Object[1];
            objectArray[0] = Mocker.intercepting(MyInterface.class, (String)"*", sb::append);
            @NotNull MethodReader mr = queue.createTailer().methodReader(objectArray);
            Assert.assertTrue((boolean)mr.readOne());
            Assert.assertFalse((boolean)mr.readOne());
            Assert.assertEquals((Object)"*doit[!net.openhft.chronicle.queue.internal.writer.ChronicleWriterTest$DTO {\n  age: 42,\n  name: Percy\n}\n]", (Object)sb.toString());
        }
        finally {
            IOTools.deleteDirWithFiles((File)this.dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testBytesMarshallingWithInterface() throws IOException {
        ChronicleWriter chronicleWriter = this.chronicleWriter(MyInterface2.class.getTypeName(), this.cw3);
        chronicleWriter.execute();
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.dir).build();){
            StringBuilder sb = new StringBuilder();
            Object[] objectArray = new Object[1];
            objectArray[0] = Mocker.intercepting(MyInterface2.class, (String)"*", sb::append);
            @NotNull MethodReader mr = queue.createTailer().methodReader(objectArray);
            Assert.assertTrue((boolean)mr.readOne());
            Assert.assertFalse((boolean)mr.readOne());
            Assert.assertEquals((Object)"*doit[!net.openhft.chronicle.queue.internal.writer.ChronicleWriterTest$DTO2 {\n  age: 42,\n  name: Percy\n}\n]", (Object)sb.toString());
        }
        finally {
            IOTools.deleteDirWithFiles((File)this.dir);
        }
    }

    private ChronicleWriter chronicleWriter(String interfaceName, String ... files) {
        ChronicleWriter chronicleWriter = new ChronicleWriter().withBasePath(this.dir.toPath()).withMethodName(METHOD_NAME).withFiles(Arrays.asList(files));
        if (interfaceName != null) {
            chronicleWriter.asMethodWriter(interfaceName);
        }
        return chronicleWriter;
    }

    public static class DTO2
    extends DTO {
        public boolean usesSelfDescribingMessage() {
            return false;
        }
    }

    public static class DTO
    extends SelfDescribingMarshallable {
        private int age;
        private String name;
    }

    public static interface MyInterface2 {
        public void doit(DTO2 var1);
    }

    public static interface MyInterface {
        public void doit(DTO var1);
    }
}

