/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.issue;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TailerTest
extends QueueTestCommon {
    public static final Path QUEUE_PATH = Paths.get("host-1/queue/broker_out", new String[0]);
    public static final int OFFSET = 3;

    @Before
    @After
    public void cleanupFiles() {
        IOTools.deleteDirWithFiles((File)QUEUE_PATH.toFile());
    }

    @Test
    public void reproduce() {
        Throwable throwable;
        IOTools.deleteDirWithFiles((File)QUEUE_PATH.toFile());
        long firstOutputIndex = Long.MAX_VALUE;
        long lastOutputIndex = Long.MIN_VALUE;
        try (ChronicleQueue q = this.createQueue();){
            throwable = null;
            try (ExcerptAppender appender = q.acquireAppender();
                 ExcerptTailer tailer2 = q.createTailer();){
                for (int i = 0; i < 5; ++i) {
                    String text = "Hello World " + i;
                    try (DocumentContext dc = appender.writingDocument();){
                        dc.wire().writeText((CharSequence)text);
                    }
                    System.out.format("Appended \"%s\" at %d%n", text, appender.lastIndexAppended());
                    firstOutputIndex = Math.min(firstOutputIndex, appender.lastIndexAppended());
                    lastOutputIndex = Math.max(lastOutputIndex, appender.lastIndexAppended());
                }
                System.out.format("firstOutputIndex = %d%n", firstOutputIndex);
                System.out.format("lastOutputIndex = %d%n", lastOutputIndex);
                System.out.println("Reading initial");
                this.drainTailer(tailer2);
            }
            catch (Throwable tailer2) {
                throwable = tailer2;
                throw tailer2;
            }
        }
        q = this.createQueue();
        var6_4 = null;
        try {
            throwable = null;
            try (ExcerptTailer tailer = q.createTailer();){
                this.initRecovery(tailer, firstOutputIndex + 3L);
                List<String> messages = this.drainTailer(tailer);
                Assert.assertEquals((Object)"Hello World 3", (Object)messages.get(0));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var6_4 = throwable3;
            throw throwable3;
        }
        finally {
            if (q != null) {
                if (var6_4 != null) {
                    try {
                        q.close();
                    }
                    catch (Throwable throwable4) {
                        var6_4.addSuppressed(throwable4);
                    }
                } else {
                    q.close();
                }
            }
        }
    }

    private List<String> drainTailer(ExcerptTailer tailer) {
        ArrayList<String> result = new ArrayList<String>();
        while (true) {
            DocumentContext dc = tailer.readingDocument();
            Throwable throwable = null;
            try {
                if (!dc.isPresent()) break;
                String text = dc.wire().readText();
                System.out.format("Tailed   \"%s\" at %d%n", text, dc.index());
                result.add(text);
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc == null) continue;
                if (throwable != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dc.close();
                continue;
            }
            break;
        }
        return result;
    }

    private void initRecovery(ExcerptTailer tailer, long index) {
        tailer.toStart();
        System.out.println("Initializing recovery to " + index);
        if (0L < index) {
            tailer.moveToIndex(index);
        }
    }

    private ChronicleQueue createQueue() {
        return ChronicleQueue.singleBuilder((Path)QUEUE_PATH).build();
    }
}

