/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.micros;

import java.util.Map;
import java.util.TreeMap;
import net.openhft.chronicle.queue.micros.MarketDataListener;
import net.openhft.chronicle.queue.micros.Order;
import net.openhft.chronicle.queue.micros.OrderIdea;
import net.openhft.chronicle.queue.micros.OrderIdeaListener;
import net.openhft.chronicle.queue.micros.OrderListener;
import net.openhft.chronicle.queue.micros.TopOfBookPrice;
import org.jetbrains.annotations.NotNull;

public class OrderManager
implements MarketDataListener,
OrderIdeaListener {
    final OrderListener orderListener;
    final Map<String, TopOfBookPrice> priceMap = new TreeMap<String, TopOfBookPrice>();
    final Map<String, OrderIdea> ideaMap = new TreeMap<String, OrderIdea>();

    public OrderManager(OrderListener orderListener) {
        this.orderListener = orderListener;
    }

    @Override
    public void onTopOfBookPrice(@NotNull TopOfBookPrice price) {
        OrderIdea idea = this.ideaMap.get(price.symbol);
        if (idea != null && this.placeOrder(price, idea)) {
            this.ideaMap.remove(price.symbol);
            return;
        }
        price.mergeToMap(this.priceMap, p -> p.symbol);
    }

    @Override
    public void onOrderIdea(@NotNull OrderIdea idea) {
        TopOfBookPrice price = this.priceMap.get(idea.symbol);
        if (price != null && this.placeOrder(price, idea)) {
            this.priceMap.remove(idea.symbol);
            return;
        }
        idea.mergeToMap(this.ideaMap, i -> i.symbol);
    }

    private boolean placeOrder(@NotNull TopOfBookPrice price, @NotNull OrderIdea idea) {
        double orderQuantity;
        double orderPrice;
        switch (idea.side) {
            case Buy: {
                if (!(price.buyPrice >= idea.limitPrice)) {
                    return false;
                }
                orderPrice = price.buyPrice;
                orderQuantity = Math.min(price.buyQuantity, idea.quantity);
                break;
            }
            case Sell: {
                if (!(price.sellPrice <= idea.limitPrice)) {
                    return false;
                }
                orderPrice = price.sellPrice;
                orderQuantity = Math.min(price.sellQuantity, idea.quantity);
                break;
            }
            default: {
                return false;
            }
        }
        this.orderListener.onOrder(new Order(idea.symbol, idea.side, orderPrice, orderQuantity));
        return true;
    }
}

