/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.watcher;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.TreeMap;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.watcher.WatcherListener;
import net.openhft.chronicle.queue.watcher.QueueFileManager;

public class QueueWatcherListener
implements WatcherListener {
    final Map<Path, QueueFileManager> queueFileManagerMap = new TreeMap<Path, QueueFileManager>();

    public void onExists(String base, String filename, Boolean modified) throws IllegalStateException {
        if (filename.endsWith(".cq4t") || filename.endsWith(".cq4")) {
            this.onExistsCQ(base, filename);
        }
    }

    void onExistsCQ(String base, String filename) {
        Path path = Paths.get(base, filename);
        Path parent = path.getParent();
        QueueFileManager fileManager = this.queueFileManagerMap.get(parent);
        if (fileManager == null) {
            String relativePath = Paths.get(filename, new String[0]).getParent().toString();
            Jvm.warn().on(this.getClass(), "File " + base + "/" + filename + " classified as Queue " + relativePath);
            fileManager = new QueueFileManager(base, relativePath);
            fileManager.start();
            this.queueFileManagerMap.put(parent, fileManager);
        }
        fileManager.onExists(path.getFileName().toString());
    }

    public void onRemoved(String base, String filename) throws IllegalStateException {
        Path path = Paths.get(base, filename);
        Path parent = path.getParent();
        QueueFileManager fileManager = this.queueFileManagerMap.get(parent);
        if (fileManager == null) {
            return;
        }
        fileManager.onRemoved(path.getFileName().toString());
        if (fileManager.isEmpty()) {
            fileManager.stop();
        }
    }
}

